/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.interceptors;

import com.amazonaws.services.simpleworkflow.flow.WorkflowClock;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.amazonaws.services.simpleworkflow.flow.core.Task;
import com.amazonaws.services.simpleworkflow.flow.core.TryFinally;
import com.amazonaws.services.simpleworkflow.flow.interceptors.AsyncExecutor;
import com.amazonaws.services.simpleworkflow.flow.interceptors.AsyncRunnable;
import com.amazonaws.services.simpleworkflow.flow.interceptors.InvocationSchedule;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncScheduledExecutor
implements AsyncExecutor {
    private final InvocationSchedule schedule;
    private final WorkflowClock clock;

    public AsyncScheduledExecutor(InvocationSchedule schedule, WorkflowClock clock) {
        this.schedule = schedule;
        this.clock = clock;
    }

    @Override
    public void execute(AsyncRunnable command) {
        this.scheduleNext(command, new Date(this.clock.currentTimeMillis()), 0, Promise.asPromise(null));
    }

    private void scheduleNext(AsyncRunnable command, Date startTime, int pastInvocationsCount, Promise<Date> invoked) {
        Date currentTime = new Date(this.clock.currentTimeMillis());
        long nextInvocationDelay = this.schedule.nextInvocationDelaySeconds(currentTime, startTime, invoked.get(), pastInvocationsCount);
        if (nextInvocationDelay >= 0L) {
            Promise<Void> nextInvocationTimer = this.clock.createTimer(nextInvocationDelay);
            this.executeAccordingToSchedule(command, startTime, pastInvocationsCount, nextInvocationTimer);
        }
    }

    private void executeAccordingToSchedule(final AsyncRunnable command, final Date startTime, final int pastInvocationsCount, Promise<Void> nextInvocationTimer) {
        final Settable invoked = new Settable();
        new TryFinally(new Promise[]{nextInvocationTimer}){
            private Date lastInvocationTime;

            protected void doTry() throws Throwable {
                this.lastInvocationTime = new Date(AsyncScheduledExecutor.this.clock.currentTimeMillis());
                command.run();
            }

            protected void doFinally() throws Throwable {
                invoked.set(this.lastInvocationTime);
            }
        };
        new Task(new Promise[]{invoked}){

            protected void doExecute() throws Throwable {
                AsyncScheduledExecutor.this.scheduleNext(command, startTime, pastInvocationsCount + 1, invoked);
            }
        };
    }
}

