/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.workman;

import java.util.ArrayList;
import java.util.List;
import org.duracloud.common.queue.task.Task;
import org.duracloud.mill.workman.MultiStepTaskProcessor;
import org.duracloud.mill.workman.TaskProcessor;
import org.duracloud.mill.workman.TaskProcessorCreationFailedException;
import org.duracloud.mill.workman.TaskProcessorFactory;

public class MultiStepTaskProcessorFactory
implements TaskProcessorFactory {
    private List<TaskProcessorFactory> factories = new ArrayList<TaskProcessorFactory>();

    public void addFactory(TaskProcessorFactory processor) {
        this.factories.add(processor);
    }

    @Override
    public TaskProcessor create(Task task) throws TaskProcessorCreationFailedException {
        MultiStepTaskProcessor processor = new MultiStepTaskProcessor();
        for (TaskProcessorFactory factory : this.factories) {
            processor.addTaskProcessor(factory.create(task));
        }
        return processor;
    }

    @Override
    public boolean isSupported(Task task) {
        for (TaskProcessorFactory factory : this.factories) {
            if (!factory.isSupported(task)) continue;
            return true;
        }
        return false;
    }
}

