/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.storagestats;

import java.util.Date;
import java.util.Map;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.mill.common.storageprovider.StorageStatsTask;
import org.duracloud.mill.storagestats.SpaceStatsManager;
import org.duracloud.mill.storagestats.aws.BucketStats;
import org.duracloud.mill.storagestats.aws.CloudWatchStorageStatsGatherer;
import org.duracloud.mill.workman.TaskExecutionFailedException;
import org.duracloud.mill.workman.TaskProcessorBase;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageStatsTaskProcessor
extends TaskProcessorBase {
    private static final Logger log = LoggerFactory.getLogger(StorageStatsTaskProcessor.class);
    private StorageStatsTask storageStatsTask;
    private StorageProvider store;
    private StorageProviderType storageProviderType;
    private SpaceStatsManager spaceStatsManager;
    private CloudWatchStorageStatsGatherer storageStatsGatherer;

    public StorageStatsTaskProcessor(StorageStatsTask storageStatsTask, StorageProvider store, StorageProviderType storageProviderType, SpaceStatsManager spaceStatsManager, CloudWatchStorageStatsGatherer storageStatsGatherer) {
        super(storageStatsTask);
        this.storageStatsTask = storageStatsTask;
        this.store = store;
        this.storageProviderType = storageProviderType;
        this.spaceStatsManager = spaceStatsManager;
        if (storageStatsGatherer == null && store instanceof S3StorageProvider) {
            throw new DuraCloudRuntimeException("The storageStatsGatherer must be non-null when the store is an instance of S3StorageProvider or one of its subclasses");
        }
        this.storageStatsGatherer = storageStatsGatherer;
    }

    @Override
    protected void executeImpl() throws TaskExecutionFailedException {
        String spaceId = this.storageStatsTask.getSpaceId();
        if (this.storageProviderType.equals((Object)StorageProviderType.AMAZON_S3) || this.storageProviderType.equals((Object)StorageProviderType.AMAZON_GLACIER) || this.storageProviderType.equals((Object)StorageProviderType.SNAPSHOT)) {
            BucketStats stats = this.storageStatsGatherer.getBucketStats(spaceId);
            this.addSpaceStats(spaceId, stats.getTotalBytes(), stats.getTotalItems());
        } else {
            Map<String, String> props = this.store.getSpaceProperties(spaceId);
            Long itemCount = this.parseLong(props, "space-count");
            Long byteCount = this.parseLong(props, "space-total-size");
            this.addSpaceStats(spaceId, byteCount, itemCount);
        }
    }

    private Long parseLong(Map<String, String> props, String key) {
        String value = props.get(key);
        if (value != null) {
            try {
                return Long.valueOf(value);
            }
            catch (Exception ex) {
                log.error("failed to parse value as long : " + ex.getMessage());
            }
        } else {
            log.warn("No value found for key {}", (Object)key);
        }
        return 0L;
    }

    private void addSpaceStats(String spaceId, long byteCount, long itemCount) {
        this.spaceStatsManager.addSpaceStats(new Date(), this.storageStatsTask.getAccount(), this.storageStatsTask.getStoreId(), spaceId, byteCount, itemCount);
    }
}

