/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.security.vote;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.duracloud.common.model.AclType;
import org.duracloud.security.domain.HttpVerb;
import org.duracloud.security.util.SecurityUtil;
import org.duracloud.security.vote.SpaceAccessVoter;
import org.duracloud.security.vote.SpaceReadAccessVoter;
import org.duracloud.security.vote.VoterUtil;
import org.duracloud.storage.domain.StorageAccount;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.error.NotFoundException;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.storage.util.StorageProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetailsService;

public class SpaceWriteAccessVoter
extends SpaceAccessVoter {
    private final Logger log = LoggerFactory.getLogger(SpaceReadAccessVoter.class);

    public SpaceWriteAccessVoter(StorageProviderFactory storageProviderFactory, UserDetailsService userDetailsService) {
        super(storageProviderFactory, userDetailsService);
    }

    public int vote(Authentication auth, Object resource, Collection config) {
        String label = "SpaceWriteAccessVoterImpl";
        if (resource != null && !this.supports((Class)resource.getClass())) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, 0));
            return 0;
        }
        HttpServletRequest httpRequest = this.getHttpServletRequest(resource);
        if (null == httpRequest) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, -1));
            return -1;
        }
        HttpVerb verb = this.getHttpVerb(httpRequest);
        if (null == verb) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, -1));
            return -1;
        }
        if (verb.isRead()) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, 0));
            return 0;
        }
        if (auth instanceof AnonymousAuthenticationToken) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, -1));
            return -1;
        }
        if (this.isRoot(auth)) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, 1));
            return 1;
        }
        if (this.isTask(httpRequest)) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, 1));
            return 1;
        }
        if (this.isSnapshotMetadataSpace(httpRequest) && this.isDeleteAction(httpRequest)) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, -1));
            return -1;
        }
        if (this.isSnapshotInProgress(httpRequest) && !this.isSpaceAclUpdate(httpRequest)) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, -1));
            return -1;
        }
        if (this.isAdmin(auth.getName())) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, 1));
            return 1;
        }
        if (this.isSpaceCreation(httpRequest)) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, -1));
            return -1;
        }
        if (this.isSpaceDeletion(httpRequest)) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, -1));
            return -1;
        }
        if (this.isSpaceAclUpdate(httpRequest)) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, -1));
            return -1;
        }
        Map<String, AclType> acls = this.getSpaceACLs(httpRequest);
        if (this.hasWriteAccess(auth.getName(), acls)) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, 1));
            return 1;
        }
        List<String> userGroups = this.getUserGroups(auth);
        if (this.groupsHaveWriteAccess(userGroups, acls)) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, 1));
            return 1;
        }
        int grant = -1;
        this.log.debug(VoterUtil.debugText(label, auth, config, resource, grant));
        return grant;
    }

    private boolean isTask(HttpServletRequest httpRequest) {
        return "task".equals(this.getSpaceId(httpRequest));
    }

    private boolean isRoot(Authentication auth) {
        return SecurityUtil.isRoot(auth);
    }

    private boolean isSnapshotInProgress(HttpServletRequest httpRequest) {
        String storeId = this.getStoreId(httpRequest);
        StorageProviderFactory factory = this.getStorageProviderFactory();
        List<StorageAccount> accounts = factory.getStorageAccounts();
        if (storeId == null) {
            for (StorageAccount account : accounts) {
                if (!account.isPrimary()) continue;
                storeId = account.getId();
                break;
            }
        }
        for (StorageAccount account : accounts) {
            if (!account.getId().equals(storeId)) continue;
            if (!account.getType().equals((Object)StorageProviderType.SNAPSHOT)) break;
            StorageProvider store = factory.getStorageProvider(storeId);
            try {
                String spaceId = this.getSpaceId(httpRequest);
                Map<String, String> spaceProps = store.getSpaceProperties(spaceId);
                if (spaceProps.containsKey("snapshot-id")) {
                    return true;
                }
            }
            catch (NotFoundException e) {}
            break;
        }
        return false;
    }

    private boolean isSpaceCreation(HttpServletRequest httpRequest) {
        if (HttpVerb.PUT.equals((Object)this.getHttpVerb(httpRequest))) {
            return !this.hasContentId(httpRequest);
        }
        return false;
    }

    private boolean isSpaceDeletion(HttpServletRequest httpRequest) {
        if (HttpVerb.DELETE.equals((Object)this.getHttpVerb(httpRequest))) {
            return !this.hasContentId(httpRequest);
        }
        return false;
    }

    private boolean isSpaceAclUpdate(HttpServletRequest httpRequest) {
        if (HttpVerb.POST.equals((Object)this.getHttpVerb(httpRequest))) {
            String path = httpRequest.getPathInfo();
            return path.startsWith("/acl/") || path.startsWith("acl/");
        }
        return false;
    }

    private boolean isDeleteAction(HttpServletRequest httpRequest) {
        return HttpVerb.DELETE.equals((Object)this.getHttpVerb(httpRequest));
    }
}

