/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.Parameter;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.io.Closeable;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.HttpAsyncClient;
import org.jclouds.rest.HttpClient;
import org.jclouds.rest.config.BinderUtils;
import org.jclouds.rest.internal.InvokeSyncToAsyncHttpMethod;

@Deprecated
public class SyncToAsyncHttpInvocationModule
extends AbstractModule {
    protected final Map<Class<?>, Class<?>> sync2Async;

    public SyncToAsyncHttpInvocationModule() {
        this(ImmutableMap.of());
    }

    public SyncToAsyncHttpInvocationModule(Map<Class<?>, Class<?>> sync2Async) {
        this.sync2Async = sync2Async;
    }

    @Override
    protected void configure() {
        this.bind(new TypeLiteral<Map<Class<?>, Class<?>>>(){}).toInstance(this.sync2Async);
        this.bind(new TypeLiteral<Function<Invocation, Object>>(){}).to(InvokeSyncToAsyncHttpMethod.class);
        BinderUtils.bindSyncToAsyncHttpApi(this.binder(), HttpClient.class, HttpAsyncClient.class);
    }

    @Provides
    @Singleton
    protected Cache<Invokable<?, ?>, Invokable<?, ?>> seedKnownSync2AsyncInvokables() {
        return SyncToAsyncHttpInvocationModule.seedKnownSync2AsyncInvokables(this.sync2Async);
    }

    @Provides
    @Singleton
    protected Function<Invocation, Invocation> sync2async(final Cache<Invokable<?, ?>, Invokable<?, ?>> cache) {
        return new Function<Invocation, Invocation>(){

            @Override
            public Invocation apply(Invocation in) {
                return Invocation.create((Invokable)Preconditions.checkNotNull(cache.getIfPresent(in.getInvokable()), "invokable %s not in %s", in.getInvokable(), cache), in.getArgs());
            }
        };
    }

    @VisibleForTesting
    static Cache<Invokable<?, ?>, Invokable<?, ?>> seedKnownSync2AsyncInvokables(Map<Class<?>, Class<?>> sync2Async) {
        Cache<Invokable<?, ?>, Invokable<?, ?>> sync2AsyncBuilder = CacheBuilder.newBuilder().build();
        SyncToAsyncHttpInvocationModule.putInvokables(HttpClient.class, HttpAsyncClient.class, sync2AsyncBuilder);
        for (Map.Entry<Class<?>, Class<?>> entry : sync2Async.entrySet()) {
            SyncToAsyncHttpInvocationModule.putInvokables(entry.getKey(), entry.getValue(), sync2AsyncBuilder);
        }
        return sync2AsyncBuilder;
    }

    public static void putInvokables(Class<?> sync, Class<?> async, Cache<Invokable<?, ?>, Invokable<?, ?>> cache) {
        for (Invokable<?, Object> invoked : Reflection2.methods(sync)) {
            Invokable delegatedMethod = Reflection2.method(async, invoked.getName(), SyncToAsyncHttpInvocationModule.getParameterTypes(invoked));
            Preconditions.checkArgument(delegatedMethod.getExceptionTypes().equals(invoked.getExceptionTypes()) || SyncToAsyncHttpInvocationModule.isCloseable(delegatedMethod), "invoked %s has different typed exceptions than target %s", invoked, delegatedMethod);
            cache.put(invoked, delegatedMethod);
        }
    }

    private static boolean isCloseable(Invokable<?, ?> delegatedMethod) {
        return "close".equals(delegatedMethod.getName()) && Closeable.class.isAssignableFrom(delegatedMethod.getDeclaringClass());
    }

    private static Class<?>[] getParameterTypes(Invokable<?, ?> in) {
        return Iterables.toArray(Iterables.transform(Preconditions.checkNotNull(in, "invokable").getParameters(), new Function<Parameter, Class<?>>(){

            @Override
            public Class<?> apply(Parameter input) {
                return input.getType().getRawType();
            }
        }), Class.class);
    }
}

