/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.bit;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.lang3.StringUtils;
import org.duracloud.common.util.DateUtil;
import org.duracloud.mill.bit.BitIntegrityCheckTask;
import org.duracloud.mill.bitlog.BitLogItem;
import org.duracloud.storage.domain.StorageProviderType;

public class BitIntegrityHelper {
    private static DateFormat dateFormat = new SimpleDateFormat(DateUtil.DateFormat.DEFAULT_FORMAT.getPattern());

    public static String buildFailureMessage(String message, BitIntegrityCheckTask bitTask, StorageProviderType storageProviderType) {
        StringBuilder builder = new StringBuilder();
        builder.append("Failure to bit-integrity check content item due to: ");
        builder.append(message);
        builder.append(" Account: ");
        builder.append(bitTask.getAccount());
        builder.append(" Source StoreID: ");
        builder.append(bitTask.getStoreId());
        builder.append(" Store Type: ");
        builder.append((Object)storageProviderType);
        builder.append(" SpaceID: ");
        builder.append(bitTask.getSpaceId());
        builder.append(" ContentID: ");
        builder.append(bitTask.getContentId());
        return builder.toString();
    }

    public static String formatLogLine(BitLogItem item) {
        Object[] values = new String[]{dateFormat.format(item.getModified()), item.getAccount(), item.getStoreId(), item.getStoreType().name(), item.getSpaceId(), item.getContentId(), item.getResult().name(), item.getContentChecksum(), item.getStorageProviderChecksum(), item.getManifestChecksum(), item.getDetails()};
        return StringUtils.join(values, "\t");
    }

    public static String getHeader() {
        Object[] values = new String[]{"date-checked", "account", "store-id", "store-type", "space-id", "content-id", "result", "content-checksum", "provider-checksum", "manifest-checksum", "details"};
        return StringUtils.join(values, "\t") + "\n";
    }
}

