/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3.support;

import java.io.IOException;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;
import org.hibernate.util.EqualsHelper;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobCreatorUtils;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;

public abstract class AbstractLobType
implements UserType {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final LobHandler lobHandler;
    private final TransactionManager jtaTransactionManager;

    protected AbstractLobType() {
        this(LocalSessionFactoryBean.getConfigTimeLobHandler(), LocalSessionFactoryBean.getConfigTimeTransactionManager());
    }

    protected AbstractLobType(LobHandler lobHandler, TransactionManager jtaTransactionManager) {
        this.lobHandler = lobHandler;
        this.jtaTransactionManager = jtaTransactionManager;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean equals(Object x, Object y) throws HibernateException {
        return EqualsHelper.equals((Object)x, (Object)y);
    }

    @Override
    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    @Override
    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    @Override
    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    @Override
    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    @Override
    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    @Deprecated
    public final Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        if (this.lobHandler == null) {
            throw new IllegalStateException("No LobHandler found for configuration - lobHandler property must be set on LocalSessionFactoryBean");
        }
        try {
            return this.nullSafeGetInternal(rs, names, owner, this.lobHandler);
        }
        catch (IOException ex) {
            throw new HibernateException("I/O errors during LOB access", ex);
        }
    }

    @Deprecated
    public final void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (this.lobHandler == null) {
            throw new IllegalStateException("No LobHandler found for configuration - lobHandler property must be set on LocalSessionFactoryBean");
        }
        LobCreator lobCreator = this.lobHandler.getLobCreator();
        try {
            this.nullSafeSetInternal(st, index, value, lobCreator);
        }
        catch (IOException ex) {
            throw new HibernateException("I/O errors during LOB access", ex);
        }
        LobCreatorUtils.registerTransactionSynchronization(lobCreator, this.jtaTransactionManager);
    }

    protected abstract Object nullSafeGetInternal(ResultSet var1, String[] var2, Object var3, LobHandler var4) throws SQLException, IOException, HibernateException;

    protected abstract void nullSafeSetInternal(PreparedStatement var1, int var2, Object var3, LobCreator var4) throws SQLException, IOException, HibernateException;
}

