/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.manifest;

import java.util.Date;
import org.duracloud.audit.task.AuditTask;
import org.duracloud.mill.manifest.ManifestStore;
import org.duracloud.mill.workman.TaskExecutionFailedException;
import org.duracloud.mill.workman.TaskProcessorBase;
import org.duracloud.mill.workman.TransProcessorState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestWritingProcessor
extends TaskProcessorBase {
    private static Logger log = LoggerFactory.getLogger(ManifestWritingProcessor.class);
    private AuditTask task;
    private ManifestStore manifestStore;

    public ManifestWritingProcessor(AuditTask task, ManifestStore manifestStore) {
        super(task);
        this.task = task;
        this.manifestStore = manifestStore;
    }

    @Override
    protected void executeImpl() throws TaskExecutionFailedException {
        try {
            String account = this.task.getAccount();
            String storeId = this.task.getStoreId();
            String spaceId = this.task.getSpaceId();
            String contentId = this.task.getContentId();
            String action = this.task.getAction();
            Date timeStamp = new Date(Long.parseLong(this.task.getDateTime()));
            if (AuditTask.ActionType.ADD_CONTENT.name().equals(action) || AuditTask.ActionType.COPY_CONTENT.name().equals(action)) {
                String size;
                String mimetype = this.task.getContentMimetype();
                if (mimetype == null) {
                    mimetype = "application/octet-stream";
                }
                if ((size = this.task.getContentSize()) == null) {
                    size = "0";
                }
                if (!this.manifestStore.addUpdate(account, storeId, spaceId, contentId, this.task.getContentChecksum(), mimetype, size, timeStamp)) {
                    TransProcessorState.ignore();
                }
            } else if (AuditTask.ActionType.DELETE_CONTENT.name().equals(action)) {
                if (!this.manifestStore.flagAsDeleted(account, storeId, spaceId, contentId, timeStamp)) {
                    TransProcessorState.ignore();
                }
            } else {
                log.debug("action {} not handled by this processor: task={}", (Object)action, (Object)this.task);
            }
            log.info("audit task successfully processed: {}", (Object)this.task);
        }
        catch (Exception e) {
            String message = "Failed to execute " + this.task + ": " + e.getMessage();
            log.debug(message, e);
            throw new TaskExecutionFailedException(message, e);
        }
    }
}

