/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.storagestats.aws;

import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.cloudwatch.model.Datapoint;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsResult;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.duracloud.mill.storagestats.aws.BucketStats;
import org.duracloud.s3storage.S3StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudWatchStorageStatsGatherer {
    private Logger log = LoggerFactory.getLogger(CloudWatchStorageStatsGatherer.class);
    private AmazonCloudWatchClient cloudWatchClient;
    private S3StorageProvider s3StorageProvider;

    public CloudWatchStorageStatsGatherer(AmazonCloudWatchClient cloudWatchClient, S3StorageProvider s3StorageProvider) {
        this.cloudWatchClient = cloudWatchClient;
        this.s3StorageProvider = s3StorageProvider;
    }

    public BucketStats getBucketStats(String spaceId) {
        this.log.info("Starting storage reporter for space {}", (Object)spaceId);
        String bucketName = this.s3StorageProvider.getBucketName(spaceId);
        BucketStats bucketDetails = new BucketStats();
        bucketDetails.setBucketName(bucketName);
        bucketDetails.setTotalItems(this.getTotalItems(bucketName, this.cloudWatchClient));
        bucketDetails.setTotalBytes(this.getTotalBytes(bucketName, this.cloudWatchClient));
        return bucketDetails;
    }

    private long getTotalItems(String bucketName, AmazonCloudWatchClient client) {
        return this.getMetricData(bucketName, "NumberOfObjects", "AllStorageTypes", client);
    }

    private long getTotalBytes(String bucketName, AmazonCloudWatchClient client) {
        long totalBytes = 0L;
        totalBytes += this.getMetricData(bucketName, "BucketSizeBytes", "StandardStorage", client);
        totalBytes += this.getMetricData(bucketName, "BucketSizeBytes", "StandardIAStorage", client);
        return totalBytes += this.getMetricData(bucketName, "BucketSizeBytes", "ReducedRedundancyStorage", client);
    }

    private long getMetricData(String bucketName, String metricName, String storageType, AmazonCloudWatchClient client) {
        GetMetricStatisticsRequest request = this.buildRequest(bucketName, metricName, storageType);
        GetMetricStatisticsResult result = client.getMetricStatistics(request);
        List<Datapoint> datapoints = result.getDatapoints();
        if (datapoints.size() > 0) {
            return datapoints.get(0).getMaximum().longValue();
        }
        return 0L;
    }

    private GetMetricStatisticsRequest buildRequest(String bucketName, String metricName, String storageType) {
        GetMetricStatisticsRequest request = new GetMetricStatisticsRequest();
        request.setMetricName(metricName);
        request.setNamespace("AWS/S3");
        request.setPeriod(360);
        request.setStatistics(Collections.singletonList("Maximum"));
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        request.setStartTime(cal.getTime());
        request.setEndTime(new Date());
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        dimensions.add(new Dimension().withName("BucketName").withValue(bucketName));
        dimensions.add(new Dimension().withName("StorageType").withValue(storageType));
        request.setDimensions(dimensions);
        return request;
    }
}

