/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.workman;

import java.text.MessageFormat;
import java.util.Date;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.duracloud.common.queue.TaskNotFoundException;
import org.duracloud.common.queue.TaskQueue;
import org.duracloud.common.queue.task.Task;
import org.duracloud.mill.workman.TaskProcessor;
import org.duracloud.mill.workman.TaskProcessorFactory;
import org.duracloud.mill.workman.TaskWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskWorkerImpl
implements TaskWorker {
    private static Logger log = LoggerFactory.getLogger(TaskWorkerImpl.class);
    private ScheduledThreadPoolExecutor timer;
    private TaskProcessorFactory processorFactory;
    private TaskQueue queue;
    private TaskQueue deadLetterQueue;
    private boolean done = false;
    private boolean started = false;
    private Runnable currentTimerTask;
    private Task task;
    private boolean initialized = false;

    public TaskWorkerImpl(Task task, TaskProcessorFactory processorFactory, TaskQueue queue, TaskQueue deadLetterQueue, ScheduledThreadPoolExecutor timer) {
        if (task == null) {
            throw new IllegalArgumentException("task must be non-null");
        }
        if (queue == null) {
            throw new IllegalArgumentException("queue must be non-null");
        }
        if (deadLetterQueue == null) {
            throw new IllegalArgumentException("deadLetterQueue must be non-null");
        }
        if (processorFactory == null) {
            throw new IllegalArgumentException("processor must be non-null");
        }
        if (timer == null) {
            throw new IllegalArgumentException("timer must be non-null");
        }
        this.task = task;
        this.processorFactory = processorFactory;
        this.queue = queue;
        this.deadLetterQueue = deadLetterQueue;
        this.timer = timer;
        log.debug("new worker created {}", (Object)this);
    }

    private void scheduleVisibilityTimeoutExtender(final Task task, Date timeFrom, final Integer visibilityTimeout) {
        Runnable timerTask;
        long delay = (long)((double)(visibilityTimeout * 1000) * 0.5);
        this.currentTimerTask = timerTask = new Runnable(){

            @Override
            public void run() {
                if (!TaskWorkerImpl.this.done) {
                    try {
                        log.debug("extending timeout of {} {} seconds", (Object)task, (Object)visibilityTimeout);
                        TaskWorkerImpl.this.queue.extendVisibilityTimeout(task);
                        log.debug("timeout extended for {}", (Object)task);
                        TaskWorkerImpl.this.scheduleVisibilityTimeoutExtender(task, new Date(), visibilityTimeout);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), e);
                    }
                }
            }
        };
        this.timer.schedule(this.currentTimerTask, delay, TimeUnit.MILLISECONDS);
    }

    protected void init() {
        log.debug("taskworker {} initializing...", (Object)this);
        this.scheduleVisibilityTimeoutExtender(this.task, new Date(), this.task.getVisibilityTimeout());
        log.debug("taskworker {} initialized", (Object)this);
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        log.debug("taskworker run starting...", (Object)this);
        if (!this.initialized) {
            String error = "The taskworker must be initialized before it can be run";
            log.error(error);
            throw new RuntimeException(error);
        }
        if (this.done || this.started) {
            log.warn("task worker {} can only be run once:  started={}, done={}. Ignoring...", this, this.started, this.done);
            return;
        }
        this.started = true;
        try {
            log.debug("{} dequeued {}", (Object)this, (Object)this.task);
            TaskProcessor processor = this.processorFactory.create(this.task);
            processor.execute();
            this.deleteTaskFromQueue(this.task);
            log.info("completed task:  task_type={} task_class={} attempts={} result={} elapsed_time={}", new Object[]{this.task.getType(), this.task.getClass().getSimpleName(), this.task.getAttempts(), "success", System.currentTimeMillis() - startTime});
        }
        catch (Throwable t) {
            int attempts = this.task.getAttempts();
            log.error(MessageFormat.format("failed to complete:  task_type={0} attempts={1} result=failure elapsed_time={2} properties=\"{3}\" message=\"{4}\"", this.task.getType().name(), attempts, System.currentTimeMillis() - startTime, this.task.getProperties(), t.getMessage()), t);
            if (attempts < 4) {
                this.requeueTask(this.task);
            } else {
                this.task.addProperty("error", t.getClass().getName() + ":" + t.getMessage());
                this.sendToDeadLetterQueue(this.task);
            }
        }
        finally {
            this.done = true;
            if (this.currentTimerTask != null) {
                this.timer.remove(this.currentTimerTask);
            }
            log.debug("task worker finished {}", (Object)this.task);
        }
    }

    private void requeueTask(Task task) {
        try {
            this.queue.requeue(task);
        }
        catch (Throwable e) {
            log.error(MessageFormat.format("failed to requeue task: task_type={0} properties=\"{1}\" message=\"{2}\"", task.getType().name(), task.getProperties(), e.getMessage()), e);
        }
    }

    private void sendToDeadLetterQueue(Task task) {
        log.info("putting {} on dead letter queue", (Object)task);
        try {
            this.deleteTaskFromQueue(task);
            this.deadLetterQueue.put(task);
            log.info("sent {} to dead-letter-queue={}", (Object)task, (Object)this.deadLetterQueue.getName());
        }
        catch (Throwable e) {
            log.error(MessageFormat.format("failed to send to dead letter queue:  task_type={0} properties=\"{1}\" message=\"{2}\"", task.getType().name(), task.getProperties(), e.getMessage()), e);
        }
    }

    private void deleteTaskFromQueue(Task task) {
        try {
            log.debug("deleting {} from {}", (Object)task, (Object)this.queue);
            this.queue.deleteTask(task);
        }
        catch (TaskNotFoundException e) {
            log.error("Error deleting " + task + ". This should never happen: " + e.getMessage(), e);
        }
    }
}

