/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.workman;

import java.util.LinkedList;
import java.util.List;
import org.duracloud.common.queue.task.Task;
import org.duracloud.mill.workman.TaskProcessor;
import org.duracloud.mill.workman.TaskProcessorCreationFailedException;
import org.duracloud.mill.workman.TaskProcessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootTaskProcessorFactory
implements TaskProcessorFactory {
    private static Logger log = LoggerFactory.getLogger(RootTaskProcessorFactory.class);
    private List<TaskProcessorFactory> factories;

    public RootTaskProcessorFactory() {
        log.debug("creating new...");
        this.factories = new LinkedList<TaskProcessorFactory>();
    }

    @Override
    public boolean isSupported(Task task) {
        for (TaskProcessorFactory factory : this.factories) {
            if (!factory.isSupported(task)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TaskProcessor create(Task task) throws TaskProcessorCreationFailedException {
        TaskProcessor p = null;
        for (TaskProcessorFactory factory : this.factories) {
            if (factory.isSupported(task)) {
                p = factory.create(task);
                break;
            }
            log.debug("task processor {} does not support {}, trying next processor...", (Object)p, (Object)task);
        }
        if (p == null) {
            throw new TaskProcessorCreationFailedException(task + " is not supported: no compatible TaskProcessorFactory found.");
        }
        return p;
    }

    public void addTaskProcessorFactory(TaskProcessorFactory factory) {
        log.debug("Adding {}", (Object)factory);
        this.factories.add(factory);
    }
}

