/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.audit;

import java.util.Date;
import java.util.Map;
import org.duracloud.audit.task.AuditTask;
import org.duracloud.mill.audit.AuditLogStoreUtil;
import org.duracloud.mill.auditor.AuditLogStore;
import org.duracloud.mill.workman.TaskExecutionFailedException;
import org.duracloud.mill.workman.TaskProcessorBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionSystemException;

public class AuditLogWritingProcessor
extends TaskProcessorBase {
    private final Logger log = LoggerFactory.getLogger(AuditLogWritingProcessor.class);
    private AuditLogStore auditLogStore;
    private AuditTask task;

    public AuditLogWritingProcessor(AuditTask task, AuditLogStore auditLogStore) {
        super(task);
        this.auditLogStore = auditLogStore;
        this.task = task;
    }

    @Override
    protected void executeImpl() throws TaskExecutionFailedException {
        try {
            String account = this.task.getAccount();
            String storeId = this.task.getStoreId();
            String spaceId = this.task.getSpaceId();
            String contentId = this.task.getContentId();
            String action = this.task.getAction();
            Map<String, String> props = this.task.getContentProperties();
            String acls = this.task.getSpaceACLs();
            Date timestamp = new Date(Long.valueOf(this.task.getDateTime()));
            this.auditLogStore.write(account, storeId, spaceId, contentId, this.task.getContentChecksum(), this.task.getContentMimetype(), this.task.getContentSize(), this.task.getUserId(), action, props != null ? AuditLogStoreUtil.serialize(props) : null, acls, this.task.getSourceSpaceId(), this.task.getSourceContentId(), timestamp);
            this.log.debug("audit task successfully processed: {}", (Object)this.task);
        }
        catch (TransactionSystemException e) {
            this.log.error("failed to write item  ( account={} storeId={} spaceId={} contentId={} timestamp={} ) to the database due to a transactional error. Likely cause: duplicate entry. Details: {}. Ignoring...", this.task.getAccount(), this.task.getStoreId(), this.task.getSpaceId(), this.task.getContentId(), new Date(Long.valueOf(this.task.getDateTime())), e.getMessage());
        }
        catch (Exception e) {
            String message = "Failed to execute " + this.task + ": " + e.getMessage();
            this.log.debug(message, e);
            throw new TaskExecutionFailedException(message, e);
        }
    }
}

