/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.workman;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.duracloud.common.queue.TaskQueue;
import org.duracloud.common.queue.task.Task;
import org.duracloud.mill.workman.TaskProcessorFactory;
import org.duracloud.mill.workman.TaskWorkerFactory;
import org.duracloud.mill.workman.TaskWorkerImpl;

public class TaskWorkerFactoryImpl
implements TaskWorkerFactory {
    private TaskProcessorFactory processorFactory;
    private TaskQueue deadLetterQueue;
    private ScheduledThreadPoolExecutor timer;

    public TaskWorkerFactoryImpl(TaskProcessorFactory factory, TaskQueue deadLetterQueue) {
        if (factory == null) {
            throw new IllegalArgumentException("processorFactory must be non-null");
        }
        this.processorFactory = factory;
        if (deadLetterQueue == null) {
            throw new IllegalArgumentException("deadLetterQueue must be non-null");
        }
        this.deadLetterQueue = deadLetterQueue;
        this.timer = new ScheduledThreadPoolExecutor(5);
    }

    @Override
    public TaskWorkerImpl create(Task task, TaskQueue queue) {
        TaskWorkerImpl taskWorker = new TaskWorkerImpl(task, this.processorFactory, queue, this.deadLetterQueue, this.timer);
        taskWorker.init();
        return taskWorker;
    }

    @Override
    public void destroy() {
        this.timer.shutdown();
    }
}

