/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.dup;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.duracloud.mill.dup.DuplicationStorePolicy;

public class DuplicationPolicy {
    private static final ObjectMapper objMapper = new ObjectMapper();
    private Map<String, LinkedHashSet<DuplicationStorePolicy>> spaceDuplicationStorePolicies = new HashMap<String, LinkedHashSet<DuplicationStorePolicy>>();
    private LinkedHashSet<DuplicationStorePolicy> defaultPolicies = new LinkedHashSet();
    private List<String> spacesToIgnore = new LinkedList<String>();
    private static Set<DuplicationStorePolicy> EMPTY_SET = Collections.unmodifiableSet(new HashSet(0));

    public LinkedHashSet<DuplicationStorePolicy> getDefaultPolicies() {
        return this.defaultPolicies;
    }

    public List<String> getSpacesToIgnore() {
        return this.spacesToIgnore;
    }

    public Map<String, LinkedHashSet<DuplicationStorePolicy>> getSpaceDuplicationStorePolicies() {
        return this.spaceDuplicationStorePolicies;
    }

    @JsonIgnore
    public Set<String> getSpaces() {
        return this.spaceDuplicationStorePolicies.keySet();
    }

    public Set<DuplicationStorePolicy> getDuplicationStorePolicies(String spaceId) {
        if (!spaceId.startsWith("x-") && !this.spacesToIgnore.contains(spaceId)) {
            LinkedHashSet<DuplicationStorePolicy> policies = this.spaceDuplicationStorePolicies.get(spaceId);
            return policies != null && !policies.isEmpty() ? policies : this.defaultPolicies;
        }
        return EMPTY_SET;
    }

    public boolean addDuplicationStorePolicy(String spaceId, DuplicationStorePolicy dupStore) {
        LinkedHashSet<DuplicationStorePolicy> dupStores = this.spaceDuplicationStorePolicies.get(spaceId);
        if (dupStores == null) {
            dupStores = new LinkedHashSet();
            this.spaceDuplicationStorePolicies.put(spaceId, dupStores);
        }
        return dupStores.add(dupStore);
    }

    public static DuplicationPolicy unmarshall(InputStream policyStream) throws IOException {
        return objMapper.readValue(policyStream, DuplicationPolicy.class);
    }

    public static String marshall(DuplicationPolicy duplicationPolicy) throws IOException {
        return objMapper.writeValueAsString(duplicationPolicy);
    }
}

