/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.dup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.duracloud.common.retry.ExceptionHandler;
import org.duracloud.common.retry.Retriable;
import org.duracloud.common.retry.Retrier;
import org.duracloud.common.util.ChecksumUtil;
import org.duracloud.mill.db.model.ManifestItem;
import org.duracloud.mill.dup.DuplicationTaskExecutionFailedException;
import org.duracloud.mill.manifest.ManifestStore;
import org.duracloud.mill.task.DuplicationTask;
import org.duracloud.mill.workman.TaskExecutionFailedException;
import org.duracloud.mill.workman.TaskProcessorBase;
import org.duracloud.storage.error.NotFoundException;
import org.duracloud.storage.error.StorageStateException;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicationTaskProcessor
extends TaskProcessorBase {
    private DuplicationTask dupTask;
    private StorageProvider sourceStore;
    private StorageProvider destStore;
    private File workDir;
    private ManifestStore manifestStore;
    private final Logger log = LoggerFactory.getLogger(DuplicationTaskProcessor.class);

    public DuplicationTaskProcessor(DuplicationTask dupTask, StorageProvider sourceStore, StorageProvider destStore, File workDir, ManifestStore manifestStore) {
        super(dupTask);
        this.dupTask = dupTask;
        this.sourceStore = sourceStore;
        this.destStore = destStore;
        this.workDir = workDir;
        this.manifestStore = manifestStore;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void executeImpl() throws TaskExecutionFailedException {
        String spaceId = this.dupTask.getSpaceId();
        String contentId = this.dupTask.getContentId();
        if (null == spaceId) throw new DuplicationTaskExecutionFailedException(this.buildFailureMessage("SpaceId value is null or empty"));
        if (spaceId.equals("")) {
            throw new DuplicationTaskExecutionFailedException(this.buildFailureMessage("SpaceId value is null or empty"));
        }
        if (null == contentId || contentId.equals("")) {
            if (this.spaceExists(this.sourceStore, spaceId)) {
                this.ensureDestSpaceExists(spaceId);
                return;
            }
            if (!this.spaceExists(this.destStore, spaceId)) return;
            Iterator<String> contentItems = this.getSpaceListing(this.destStore, spaceId);
            if (contentItems.hasNext()) return;
            this.deleteDestSpace(spaceId);
            return;
        }
        this.ensureDestSpaceExists(spaceId);
        Map<String, String> sourceProperties = this.getContentProperties(this.sourceStore, spaceId, contentId);
        Map<String, String> destProperties = this.getContentProperties(this.destStore, spaceId, contentId);
        if (null == sourceProperties) {
            if (null == destProperties) return;
            this.duplicateDeletion(spaceId, contentId);
            return;
        }
        String sourceChecksum = sourceProperties.get("content-checksum");
        this.cleanProperties(sourceProperties);
        if (null == destProperties) {
            this.duplicateContent(spaceId, contentId, sourceChecksum, sourceProperties);
            return;
        }
        String destChecksum = destProperties.get("content-checksum");
        this.cleanProperties(destProperties);
        if (null == sourceChecksum) {
            String msg = "Source content item properties included no checksum!";
            throw new DuplicationTaskExecutionFailedException(this.buildFailureMessage(msg));
        }
        if (!sourceChecksum.equals(destChecksum)) {
            this.duplicateContent(spaceId, contentId, sourceChecksum, sourceProperties);
            return;
        }
        boolean propertiesEqual = this.compareProperties(sourceProperties, destProperties);
        if (!propertiesEqual) {
            this.duplicateProperties(spaceId, contentId, sourceProperties);
            return;
        }
        this.log.info("Duplication check complete, no updates needed. Content id={} space={} account={}", contentId, spaceId, this.dupTask.getAccount());
    }

    private boolean spaceExists(final StorageProvider store, final String spaceId) throws TaskExecutionFailedException {
        try {
            return (Boolean)new Retrier().execute(new Retriable(){

                @Override
                public Boolean retry() throws Exception {
                    store.getSpaceProperties(spaceId);
                    return true;
                }
            });
        }
        catch (NotFoundException nfe) {
            return false;
        }
        catch (Exception e) {
            String msg = "Error attempting to check if space exists: " + e.getMessage();
            throw new DuplicationTaskExecutionFailedException(this.buildFailureMessage(msg), e);
        }
    }

    private void ensureDestSpaceExists(String spaceId) {
        try {
            this.destStore.createSpace(spaceId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Iterator<String> getSpaceListing(final StorageProvider store, final String spaceId) throws TaskExecutionFailedException {
        try {
            return (Iterator)new Retrier().execute(new Retriable(){

                @Override
                public Iterator<String> retry() throws Exception {
                    return store.getSpaceContents(spaceId, null);
                }
            });
        }
        catch (Exception e) {
            String msg = "Error attempting to retrieve space listing: " + e.getMessage();
            throw new DuplicationTaskExecutionFailedException(this.buildFailureMessage(msg), e);
        }
    }

    private void deleteDestSpace(final String spaceId) throws TaskExecutionFailedException {
        this.log.info("Deleting space " + spaceId + " from dest provider in account " + this.dupTask.getAccount());
        try {
            new Retrier().execute(new Retriable(){

                @Override
                public String retry() throws Exception {
                    DuplicationTaskProcessor.this.destStore.deleteSpace(spaceId);
                    return "success";
                }
            });
        }
        catch (Exception e) {
            String msg = "Error attempting to delete the destination space: " + e.getMessage();
            throw new DuplicationTaskExecutionFailedException(this.buildFailureMessage(msg), e);
        }
        this.log.info("Successfully deleted space " + spaceId + " from dest provider in account " + this.dupTask.getAccount());
    }

    private Map<String, String> getContentProperties(final StorageProvider store, final String spaceId, final String contentId) throws TaskExecutionFailedException {
        try {
            return (Map)new Retrier().execute(new Retriable(){

                @Override
                public Map<String, String> retry() throws Exception {
                    return store.getContentProperties(spaceId, contentId);
                }
            }, new ExceptionHandler(){

                @Override
                public void handle(Exception ex) {
                    if (!(ex instanceof NotFoundException)) {
                        DuplicationTaskProcessor.this.log.debug(ex.getMessage(), ex);
                    } else {
                        DuplicationTaskProcessor.this.log.debug("retry attempt failed but probably not an issue: {}", (Object)ex.getMessage());
                    }
                }
            });
        }
        catch (NotFoundException nfe) {
            return null;
        }
        catch (Exception e) {
            String msg = "Error attempting to retrieve content properties: " + e.getMessage();
            throw new DuplicationTaskExecutionFailedException(this.buildFailureMessage(msg), e);
        }
    }

    protected boolean compareProperties(Map<String, String> sourceProps, Map<String, String> destProps) {
        return sourceProps.equals(destProps);
    }

    private void duplicateProperties(final String spaceId, final String contentId, final Map<String, String> sourceProperties) throws TaskExecutionFailedException {
        this.log.info("Duplicating properties for " + contentId + " in space " + spaceId + " in account " + this.dupTask.getAccount());
        try {
            new Retrier().execute(new Retriable(){

                @Override
                public String retry() throws Exception {
                    try {
                        DuplicationTaskProcessor.this.destStore.setContentProperties(spaceId, contentId, sourceProperties);
                    }
                    catch (StorageStateException ex) {
                        String message = "Unable to set content properties on destination store ({0}) for {1} (content) in {2} (space)";
                        DuplicationTaskProcessor.this.log.warn(MessageFormat.format(message, DuplicationTaskProcessor.this.destStore, contentId, spaceId));
                    }
                    return "success";
                }
            });
            this.log.info("Successfully duplicated properties for " + contentId + " in space " + spaceId + " in account " + this.dupTask.getAccount());
        }
        catch (Exception e) {
            String msg = "Error attempting to duplicate content properties: " + e.getMessage();
            throw new DuplicationTaskExecutionFailedException(this.buildFailureMessage(msg), e);
        }
    }

    private void cleanProperties(Map<String, String> props) {
        if (props != null) {
            props.remove("content-md5");
            props.remove("content-checksum");
            props.remove("content-modified");
            props.remove("content-size");
            props.remove("Content-Length");
            props.remove("Content-Type");
            props.remove("Last-Modified");
            props.remove("Date");
            props.remove("ETag");
            props.remove("Content-Length".toLowerCase());
            props.remove("Content-Type".toLowerCase());
            props.remove("Last-Modified".toLowerCase());
            props.remove("Date".toLowerCase());
            props.remove("ETag".toLowerCase());
        }
    }

    private void duplicateContent(String spaceId, String contentId, String sourceChecksum, Map<String, String> sourceProperties) throws TaskExecutionFailedException {
        this.log.info("Duplicating " + contentId + " in space " + spaceId + " in account " + this.dupTask.getAccount());
        ChecksumUtil checksumUtil = new ChecksumUtil(ChecksumUtil.Algorithm.MD5);
        boolean localChecksumMatch = false;
        File localFile = null;
        for (int attempt = 0; !localChecksumMatch && attempt < 3; ++attempt) {
            try (InputStream sourceStream = this.getSourceContent(spaceId, contentId);){
                localFile = this.cacheContent(sourceStream);
                String localChecksum = checksumUtil.generateChecksum(localFile);
                if (sourceChecksum.equals(localChecksum)) {
                    localChecksumMatch = true;
                    continue;
                }
                this.cleanup(localFile);
                continue;
            }
            catch (Exception e) {
                this.log.warn("Error generating checksum for source content: " + e.getMessage(), e);
            }
        }
        if (!localChecksumMatch) {
            this.cleanup(localFile);
            String msg = "Unable to retrieve content which matches the expected source checksum of: " + sourceChecksum;
            throw new DuplicationTaskExecutionFailedException(this.buildFailureMessage(msg));
        }
        this.putDestinationContent(spaceId, contentId, sourceChecksum, sourceProperties, localFile);
        this.log.info("Successfully duplicated id={} dup_size={} space={} account={}", contentId, localFile.length(), spaceId, this.dupTask.getAccount());
        this.cleanup(localFile);
    }

    private InputStream getSourceContent(final String spaceId, final String contentId) throws TaskExecutionFailedException {
        try {
            return (InputStream)new Retrier().execute(new Retriable(){

                @Override
                public InputStream retry() throws Exception {
                    return DuplicationTaskProcessor.this.sourceStore.getContent(spaceId, contentId).getContentStream();
                }
            });
        }
        catch (Exception e) {
            String msg = "Error attempting to get source content: " + e.getMessage();
            throw new DuplicationTaskExecutionFailedException(this.buildFailureMessage(msg), e);
        }
    }

    private File cacheContent(InputStream inStream) throws TaskExecutionFailedException {
        File localFile = null;
        try {
            localFile = File.createTempFile("content-item", ".tmp", this.workDir);
            try (FileOutputStream outStream = FileUtils.openOutputStream(localFile);){
                IOUtils.copy(inStream, (OutputStream)outStream);
            }
            inStream.close();
        }
        catch (IOException e) {
            if (localFile != null) {
                this.cleanup(localFile);
            }
            String msg = "Unable to cache content file due to: " + e.getMessage();
            throw new DuplicationTaskExecutionFailedException(this.buildFailureMessage(msg), e);
        }
        return localFile;
    }

    private void putDestinationContent(final String spaceId, final String contentId, final String sourceChecksum, final Map<String, String> sourceProperties, final File file) throws TaskExecutionFailedException {
        try {
            new Retrier().execute(new Retriable(){

                @Override
                public String retry() throws Exception {
                    String srcMimetype = (String)sourceProperties.get("content-mimetype");
                    Throwable throwable = null;
                    try (FileInputStream destStream = FileUtils.openInputStream(file);){
                        String destChecksum = DuplicationTaskProcessor.this.destStore.addContent(spaceId, contentId, srcMimetype, sourceProperties, file.length(), sourceChecksum, destStream);
                        if (sourceChecksum.equals(destChecksum)) {
                            String string = "success";
                            return string;
                        }
                        try {
                            throw new RuntimeException("Checksum in dest does not match source");
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            this.cleanup(file);
            String msg = "Error attempting to add destination content: " + e.getMessage();
            throw new DuplicationTaskExecutionFailedException(this.buildFailureMessage(msg), e);
        }
    }

    private void cleanup(File file) {
        try {
            FileUtils.forceDelete(file);
        }
        catch (IOException e) {
            this.log.info("Unable to delete temp file: " + file.getAbsolutePath() + " due to: " + e.getMessage(), e);
        }
    }

    private void duplicateDeletion(final String spaceId, final String contentId) throws TaskExecutionFailedException {
        if (this.existsInSourceManifest(spaceId, contentId)) {
            throw new TaskExecutionFailedException(MessageFormat.format("item exists in source manifest and thus appears to be missing content.  account={0}, storeId={1}, spaceId={2}, contentId={3}", this.dupTask.getAccount(), this.dupTask.getSourceStoreId(), spaceId, contentId));
        }
        this.log.info("Duplicating deletion of " + contentId + " in dest space " + spaceId + " in account " + this.dupTask.getAccount());
        try {
            new Retrier().execute(new Retriable(){

                @Override
                public String retry() throws Exception {
                    DuplicationTaskProcessor.this.destStore.deleteContent(spaceId, contentId);
                    return "success";
                }
            });
        }
        catch (Exception e) {
            String msg = "Error attempting to delete content : " + e.getMessage();
            throw new DuplicationTaskExecutionFailedException(this.buildFailureMessage(msg), e);
        }
        this.log.info("Successfully deleted content item (content_id=" + contentId + ") in dest space (space_id=" + spaceId + ") where account_id=" + this.dupTask.getAccount());
    }

    private boolean existsInSourceManifest(String spaceId, String contentId) {
        String sourceStoreId = this.dupTask.getSourceStoreId();
        String account = this.dupTask.getAccount();
        try {
            ManifestItem item = this.manifestStore.getItem(account, sourceStoreId, spaceId, contentId);
            if (!item.isDeleted()) {
                return true;
            }
        }
        catch (org.duracloud.common.db.error.NotFoundException notFoundException) {
            // empty catch block
        }
        return false;
    }

    private String buildFailureMessage(String message) {
        StringBuilder builder = new StringBuilder();
        builder.append("Failure to duplicate content item due to:");
        builder.append(message);
        builder.append(" Account: ");
        builder.append(this.dupTask.getAccount());
        builder.append(" Source StoreID: ");
        builder.append(this.dupTask.getStoreId());
        builder.append(" Destination StoreID: ");
        builder.append(this.dupTask.getDestStoreId());
        builder.append(" SpaceID: ");
        builder.append(this.dupTask.getSpaceId());
        builder.append(" ContentID: ");
        builder.append(this.dupTask.getContentId());
        return builder.toString();
    }
}

