/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.swiftstorage;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.duracloud.common.rest.HttpHeaders;
import org.duracloud.s3storage.S3ProviderUtil;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.error.NotFoundException;
import org.duracloud.storage.error.StorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwiftStorageProvider
extends S3StorageProvider {
    private final Logger log = LoggerFactory.getLogger(SwiftStorageProvider.class);

    public SwiftStorageProvider(String accessKey, String secretKey, Map<String, String> options) {
        super(accessKey, secretKey, options);
    }

    public SwiftStorageProvider(AmazonS3 s3Client, String accessKey) {
        super(s3Client, accessKey, null);
    }

    @Override
    public StorageProviderType getStorageProviderType() {
        return StorageProviderType.SWIFT_S3;
    }

    @Override
    protected Bucket createBucket(String spaceId) {
        String bucketName = this.getNewBucketName(spaceId);
        try {
            Bucket bucket = this.s3Client.createBucket(bucketName);
            return bucket;
        }
        catch (AmazonClientException e) {
            String err = "Could not create Swift container with name " + bucketName + " due to error: " + e.getMessage();
            throw new StorageException(err, (Throwable)e, true);
        }
    }

    @Override
    public void removeSpace(String spaceId) {
        String bucketName = this.getBucketName(spaceId);
        String propertiesBucketName = this.getBucketName("space-properties");
        try {
            this.s3Client.deleteBucket(bucketName);
        }
        catch (AmazonClientException e) {
            String err = "Could not delete Swift container with name " + bucketName + " due to error: " + e.getMessage();
            throw new StorageException(err, (Throwable)e, true);
        }
        this.s3Client.deleteObject(propertiesBucketName, spaceId);
    }

    @Override
    public String createHiddenSpace(String spaceId, int expirationInDays) {
        String bucketName = this.getHiddenBucketName(spaceId);
        try {
            Bucket bucket = this.s3Client.createBucket(bucketName);
            return spaceId;
        }
        catch (AmazonClientException e) {
            String err = "Could not create Swift container with name " + bucketName + " due to error: " + e.getMessage();
            throw new StorageException(err, (Throwable)e, true);
        }
    }

    @Override
    protected String getNewBucketName(String spaceId) {
        String truncatedKey = this.truncateKey(this.accessKeyId);
        return S3ProviderUtil.createNewBucketName(truncatedKey, spaceId);
    }

    @Override
    protected String getSpaceId(String bucketName) {
        String spaceId = bucketName;
        String truncatedKey = this.truncateKey(this.accessKeyId);
        if (this.isSpace(bucketName)) {
            spaceId = spaceId.substring(truncatedKey.length() + 1);
        }
        return spaceId;
    }

    @Override
    protected Map<String, String> getAllSpaceProperties(String spaceId) {
        this.log.debug("getAllSpaceProperties(" + spaceId + ")");
        String propsBucketName = this.getBucketName("space-properties");
        Map<String, String> spaceProperties = new HashMap<String, String>();
        try {
            String[] spacePropertiesList;
            String spacePropertiesString = this.s3Client.getObjectAsString(propsBucketName, spaceId);
            spacePropertiesString = spacePropertiesString.substring(1, spacePropertiesString.length() - 1);
            for (String property : spacePropertiesList = spacePropertiesString.split(", ")) {
                String[] props = property.split("=");
                spaceProperties.put(props[0], props[1]);
            }
        }
        catch (AmazonS3Exception e) {
            this.log.debug("Metadata object for space " + spaceId + " was not found in container " + propsBucketName + ", probably because this is a new space.");
        }
        spaceProperties = this.replaceInMapValues(spaceProperties, "+", "@");
        spaceProperties.put("space-count", this.getSpaceCount(spaceId, 1000));
        return spaceProperties;
    }

    @Override
    protected void doSetSpaceProperties(String spaceId, Map<String, String> spaceProperties) {
        Map<String, String> originalProperties;
        this.log.debug("setSpaceProperties(" + spaceId + ")");
        try {
            originalProperties = this.getAllSpaceProperties(spaceId);
        }
        catch (NotFoundException e) {
            this.createHiddenSpace("space-properties", 0);
            originalProperties = new HashMap<String, String>();
        }
        String metadataBucketName = this.getBucketName("space-properties");
        String creationDate = originalProperties.get("space-created");
        if (creationDate == null && (creationDate = spaceProperties.get("space-created")) == null) {
            creationDate = this.formattedDate(new Date());
        }
        spaceProperties.put("space-created", creationDate);
        spaceProperties = this.replaceInMapValues(spaceProperties, "@", "+");
        this.log.debug("Writing space properties " + spaceProperties.toString() + " to object " + spaceId + " in Swift container " + metadataBucketName);
        this.s3Client.putObject(metadataBucketName, spaceId, spaceProperties.toString());
    }

    @Override
    protected void updateObjectProperties(String bucketName, String contentId, ObjectMetadata objMetadata) {
        try {
            AccessControlList originalACL = this.s3Client.getObjectAcl(bucketName, contentId);
            CopyObjectRequest copyRequest = new CopyObjectRequest(bucketName, contentId, bucketName, contentId);
            copyRequest.setStorageClass(DEFAULT_STORAGE_CLASS);
            copyRequest.setNewObjectMetadata(objMetadata);
            copyRequest.setAccessControlList(originalACL);
            this.s3Client.copyObject(copyRequest);
        }
        catch (AmazonClientException e) {
            this.throwIfContentNotExist(bucketName, contentId);
            String err = "Could not update metadata for content " + contentId + " in Swift container " + bucketName + " due to error: " + e.getMessage();
            throw new StorageException(err, (Throwable)e, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Map<String, String> prepContentProperties(ObjectMetadata objMetadata) {
        Date modified;
        String checksum;
        long contentLength;
        String encoding;
        HashMap<String, String> contentProperties = new HashMap<String, String>();
        Map<String, String> userProperties = objMetadata.getUserMetadata();
        for (String string : userProperties.keySet()) {
            void var5_5;
            String metaValue = userProperties.get(string);
            if (string.trim().equalsIgnoreCase("tags") || string.trim().equalsIgnoreCase("tags*") || string.trim().equalsIgnoreCase("content-mimetype") || string.trim().equalsIgnoreCase("content-mimetype*")) {
                String string2 = string.toLowerCase();
            }
            contentProperties.put(this.getWithSpace(SwiftStorageProvider.decodeHeaderKey((String)var5_5)), SwiftStorageProvider.decodeHeaderValue(metaValue));
        }
        Map<String, Object> responseMeta = objMetadata.getRawMetadata();
        for (String metaName : responseMeta.keySet()) {
            try {
                if (!this.isSwiftMetadata(metaName)) {
                    Object metaValue = responseMeta.get(metaName);
                    if (metaName.trim().equalsIgnoreCase("ETag")) {
                        metaName = "ETag";
                    }
                    contentProperties.put(metaName, String.valueOf(metaValue));
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            if (!userProperties.keySet().contains(metaName + "*") || !contentProperties.containsKey(metaName)) continue;
            contentProperties.remove(metaName);
        }
        String string = objMetadata.getContentType();
        if (string != null) {
            contentProperties.put("content-mimetype", string);
            contentProperties.put("Content-Type", string);
        }
        if ((encoding = objMetadata.getContentEncoding()) != null) {
            contentProperties.put("Content-Encoding", encoding);
        }
        if ((contentLength = objMetadata.getContentLength()) >= 0L) {
            String size = String.valueOf(contentLength);
            contentProperties.put("content-size", size);
            contentProperties.put("Content-Length", size);
        }
        if ((checksum = objMetadata.getETag()) != null) {
            String eTagValue = this.getETagValue(checksum);
            contentProperties.put("content-checksum", eTagValue);
            contentProperties.put("content-md5", eTagValue);
            contentProperties.put("ETag", eTagValue);
        }
        if ((modified = objMetadata.getLastModified()) != null) {
            String modDate = this.formattedDate(modified);
            contentProperties.put("content-modified", modDate);
            contentProperties.put("Last-Modified", modDate);
        }
        return contentProperties;
    }

    private String truncateKey(String accessKey) {
        return StringUtils.left(accessKey, 20);
    }

    private boolean isSwiftMetadata(String metaName) {
        Field[] httpFields;
        for (Field f : httpFields = HttpHeaders.class.getFields()) {
            String fieldName = null;
            try {
                fieldName = (String)f.get(httpFields);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
            if (!metaName.equalsIgnoreCase(fieldName)) continue;
            return false;
        }
        return true;
    }

    public ObjectMetadata expireObject(String bucketName, String contentId, Integer seconds) {
        this.log.debug("Expiring object {} in {} after {} seconds.", contentId, bucketName, seconds);
        ObjectMetadata objMetadata = this.getObjectDetails(bucketName, contentId, true);
        objMetadata.setHeader("X-Delete-After", seconds);
        this.updateObjectProperties(bucketName, contentId, objMetadata);
        return objMetadata;
    }

    private ObjectMetadata getObjectDetails(String bucketName, String contentId, boolean retry) {
        try {
            return this.s3Client.getObjectMetadata(bucketName, contentId);
        }
        catch (AmazonClientException e) {
            this.throwIfContentNotExist(bucketName, contentId);
            String err = "Could not get details for content " + contentId + " in Swift container " + bucketName + " due to error: " + e.getMessage();
            throw new StorageException(err, (Throwable)e, retry);
        }
    }
}

