/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.bit;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Date;
import java.util.Iterator;
import org.duracloud.common.collection.WriteOnlyStringSet;
import org.duracloud.mill.bit.BitIntegrityCheckReportTask;
import org.duracloud.mill.bitlog.BitIntegrityResult;
import org.duracloud.mill.bitlog.BitLogStore;
import org.duracloud.mill.db.model.ManifestItem;
import org.duracloud.mill.manifest.ManifestStore;
import org.duracloud.mill.workman.TaskExecutionFailedException;
import org.duracloud.mill.workman.TaskProcessor;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceComparisonTaskProcessor
implements TaskProcessor {
    private static Logger log = LoggerFactory.getLogger(SpaceComparisonTaskProcessor.class);
    private BitIntegrityCheckReportTask bitTask;
    private BitLogStore bitLogStore;
    private ManifestStore manifestStore;
    private StorageProvider store;
    private StorageProviderType storageProviderType;

    public SpaceComparisonTaskProcessor(BitIntegrityCheckReportTask bitTask, BitLogStore bitLogStore, ManifestStore manifestStore, StorageProvider store, StorageProviderType storageProviderType) {
        this.bitTask = bitTask;
        this.bitLogStore = bitLogStore;
        this.manifestStore = manifestStore;
        this.storageProviderType = storageProviderType;
        this.store = store;
    }

    @Override
    public void execute() throws TaskExecutionFailedException {
        String account = this.bitTask.getAccount();
        String storeId = this.bitTask.getStoreId();
        String spaceId = this.bitTask.getSpaceId();
        log.info("starting space comparison where account={} storeId={} spaceId={}", account, storeId, spaceId);
        File spaceListing = null;
        try {
            spaceListing = File.createTempFile("spaces", ".txt");
            int count = 0;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(spaceListing));){
                Iterator<String> it = this.store.getSpaceContents(spaceId, null);
                while (it.hasNext()) {
                    if (count > 0) {
                        writer.write("\n");
                    }
                    writer.write(it.next());
                    ++count;
                }
                writer.close();
            }
            WriteOnlyStringSet set = new WriteOnlyStringSet(count);
            try (BufferedReader reader = new BufferedReader(new FileReader(spaceListing));){
                String contentId = null;
                while ((contentId = reader.readLine()) != null) {
                    set.add(contentId);
                }
            }
            Iterator<ManifestItem> manifestIterator = this.manifestStore.getItems(account, storeId, spaceId, false);
            while (manifestIterator.hasNext()) {
                ManifestItem item = manifestIterator.next();
                String contentId = item.getContentId();
                if (set.contains(contentId)) {
                    if (!item.isMissingFromStorageProvider()) continue;
                    this.manifestStore.updateMissingFromStorageProviderFlag(account, storeId, spaceId, contentId, false);
                    continue;
                }
                log.debug("no content found in storage provider for manifest item: {}", (Object)item);
                if (item.isDeleted()) continue;
                if (item.isMissingFromStorageProvider()) {
                    this.bitLogStore.write(account, storeId, spaceId, contentId, new Date(), this.storageProviderType, BitIntegrityResult.ERROR, null, null, item.getContentChecksum(), "Content item is in the manifest but not in the storage provider in the course of the last two bit integrity runs.");
                    continue;
                }
                this.manifestStore.updateMissingFromStorageProviderFlag(account, storeId, spaceId, contentId, true);
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            throw new TaskExecutionFailedException("failed to complete task: " + ex.getMessage(), ex);
        }
        finally {
            if (spaceListing != null && spaceListing.exists()) {
                spaceListing.delete();
            }
        }
    }
}

