/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.config;

import org.apache.commons.lang3.StringUtils;
import org.duracloud.common.model.EmailerType;
import org.duracloud.common.queue.QueueType;

public class ConfigurationManager {
    public String getAuditQueueName() {
        return System.getProperty("queue.name.audit");
    }

    public String getBitIntegrityQueue() {
        return System.getProperty("queue.name.bit-integrity");
    }

    public String getWorkDirectoryPath() {
        return System.getProperty("workdir");
    }

    public String[] getNotificationRecipients() {
        return this.getCommaSeparatedListToArray("notification.recipients");
    }

    public String[] getSwiftConfig() {
        String[] config = new String[]{System.getProperty("swift.accessKey"), System.getProperty("swift.secretKey"), System.getProperty("swift.endpoint"), System.getProperty("swift.signerType")};
        return config;
    }

    public QueueType getQueueType() {
        String queueType = System.getProperty("queue.type");
        if (queueType != null && queueType.trim().equalsIgnoreCase(QueueType.RABBITMQ.toString())) {
            return QueueType.RABBITMQ;
        }
        return QueueType.SQS;
    }

    public String[] getRabbitMQConfig() {
        if (this.getQueueType().equals((Object)QueueType.RABBITMQ)) {
            String[] config = new String[]{System.getProperty("rabbitmq.host"), System.getProperty("rabbitmq.port"), System.getProperty("rabbitmq.vhost"), System.getProperty("rabbitmq.exchange"), System.getProperty("rabbitmq.username"), System.getProperty("rabbitmq.password")};
            return config;
        }
        return new String[0];
    }

    public EmailerType getEmailerType() {
        String emailerType = System.getProperty("emailer.type");
        if (emailerType != null && emailerType.trim().equalsIgnoreCase(EmailerType.SMTP.toString())) {
            return EmailerType.SMTP;
        }
        return EmailerType.SES;
    }

    public String[] getSMTPConfig() {
        if (this.getEmailerType().equals((Object)EmailerType.SMTP)) {
            String[] config = new String[]{System.getProperty("notification.host"), System.getProperty("notification.port"), System.getProperty("notification.user"), System.getProperty("notification.pass"), System.getProperty("notification.sender")};
            return config;
        }
        return new String[0];
    }

    private String[] getCommaSeparatedListToArray(String prop) {
        String values = System.getProperty(prop);
        if (StringUtils.isBlank(values)) {
            return new String[0];
        }
        return values.split(",");
    }

    public String[] getNotificationRecipientsNonTech() {
        return this.getCommaSeparatedListToArray("notification.recipients.non-tech");
    }
}

