/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.storagestats;

import java.util.Date;
import org.duracloud.mill.common.storageprovider.StorageStatsTask;
import org.duracloud.mill.db.repo.JpaManifestItemRepo;
import org.duracloud.mill.storagestats.SpaceStatsManager;
import org.duracloud.mill.workman.TaskExecutionFailedException;
import org.duracloud.mill.workman.TaskProcessorBase;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageStatsTaskProcessor
extends TaskProcessorBase {
    private static final Logger log = LoggerFactory.getLogger(StorageStatsTaskProcessor.class);
    private StorageStatsTask storageStatsTask;
    private StorageProvider store;
    private StorageProviderType storageProviderType;
    private SpaceStatsManager spaceStatsManager;
    private JpaManifestItemRepo manifestRepo;

    public StorageStatsTaskProcessor(StorageStatsTask storageStatsTask, StorageProvider store, StorageProviderType storageProviderType, SpaceStatsManager spaceStatsManager, JpaManifestItemRepo manifestRepo) {
        super(storageStatsTask);
        this.storageStatsTask = storageStatsTask;
        this.store = store;
        this.storageProviderType = storageProviderType;
        this.spaceStatsManager = spaceStatsManager;
        this.manifestRepo = manifestRepo;
    }

    @Override
    protected void executeImpl() throws TaskExecutionFailedException {
        String spaceId = this.storageStatsTask.getSpaceId();
        String storeId = this.storageStatsTask.getStoreId();
        String accountId = this.storageStatsTask.getAccount();
        Object[] stats = this.manifestRepo.getStorageStatsByAccountAndStoreIdAndSpaceId(accountId, storeId, spaceId);
        long itemCount = 0L;
        long byteCount = 0L;
        Object[] statRow = (Object[])stats[0];
        if (statRow[0] != null) {
            itemCount = ((Number)statRow[0]).longValue();
        }
        if (statRow[1] != null) {
            byteCount = ((Number)statRow[1]).longValue();
        }
        this.addSpaceStats(accountId, storeId, spaceId, byteCount, itemCount);
    }

    private void addSpaceStats(String accountId, String storeId, String spaceId, long byteCount, long itemCount) {
        this.spaceStatsManager.addSpaceStats(new Date(), accountId, storeId, spaceId, byteCount, itemCount);
    }
}

