/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.workman;

import java.text.MessageFormat;
import org.duracloud.common.queue.task.SpaceCentricTypedTask;
import org.duracloud.common.queue.task.TypedTask;
import org.duracloud.mill.workman.TaskExecutionFailedException;
import org.duracloud.mill.workman.TaskProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TaskProcessorBase
implements TaskProcessor {
    private static Logger log = LoggerFactory.getLogger(TaskProcessorBase.class);
    private SpaceCentricTypedTask task;

    public TaskProcessorBase(SpaceCentricTypedTask task) {
        this.task = task;
    }

    @Override
    public final void execute() throws TaskExecutionFailedException {
        long startTime = System.currentTimeMillis();
        try {
            this.executeImpl();
            log.info(this.createMessage("success", System.currentTimeMillis() - startTime));
        }
        catch (TaskExecutionFailedException ex) {
            log.error(this.createMessage("failure", System.currentTimeMillis() - startTime));
            throw ex;
        }
    }

    private String createMessage(String result, long elapsedTime) {
        String contentId = null;
        if (this.task instanceof TypedTask) {
            contentId = ((TypedTask)this.task).getContentId();
        }
        return MessageFormat.format("processor completed: processor_class={0} account={1} store_id={2} space_id={3} {4} attempts={5} result={6} elapsed_time={7}", this.getClass().getSimpleName(), this.task.getAccount(), this.task.getStoreId(), this.task.getSpaceId(), contentId == null ? "" : "content_id=" + contentId, this.task.getAttempts(), result, "" + elapsedTime);
    }

    protected SpaceCentricTypedTask getTask() {
        return this.task;
    }

    protected abstract void executeImpl() throws TaskExecutionFailedException;
}

