/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.workman;

import java.io.File;
import org.duracloud.common.queue.task.Task;
import org.duracloud.mill.credentials.CredentialsRepo;
import org.duracloud.mill.workman.TaskProcessor;
import org.duracloud.mill.workman.TaskProcessorCreationFailedException;
import org.duracloud.mill.workman.TaskProcessorFactory;

public abstract class TaskProcessorFactoryBase
implements TaskProcessorFactory {
    private CredentialsRepo credentialRepo;
    private File workDir;

    public TaskProcessorFactoryBase(CredentialsRepo credentialRepo) {
        this(credentialRepo, null);
    }

    public TaskProcessorFactoryBase(CredentialsRepo credentialRepo, File workDir) {
        this.credentialRepo = credentialRepo;
        this.workDir = workDir;
    }

    @Override
    public final TaskProcessor create(Task task) throws TaskProcessorCreationFailedException {
        if (!this.isSupported(task)) {
            throw new TaskProcessorCreationFailedException(task + " is not supported by this factory:" + this.getClass().getSimpleName());
        }
        return this.createImpl(task);
    }

    protected CredentialsRepo getCredentialRepo() {
        return this.credentialRepo;
    }

    protected File getWorkDir() {
        return this.workDir;
    }

    @Override
    public abstract boolean isSupported(Task var1);

    protected abstract TaskProcessor createImpl(Task var1) throws TaskProcessorCreationFailedException;
}

