/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.s3storage;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Region;
import com.amazonaws.services.cloudfront.AmazonCloudFrontClient;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.AmazonS3URI;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.duracloud.storage.domain.StorageAccount;
import org.duracloud.storage.error.StorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class S3ProviderUtil {
    private static final Logger log = LoggerFactory.getLogger(S3ProviderUtil.class);
    private static Map<String, AmazonS3> s3Clients = new HashMap<String, AmazonS3>();
    private static Map<String, AmazonCloudFrontClient> cloudFrontClients = new HashMap<String, AmazonCloudFrontClient>();

    private S3ProviderUtil() {
    }

    public static AmazonS3 getAmazonS3Client(String accessKey, String secretKey, Map<String, String> options) {
        AmazonS3 client = s3Clients.get(S3ProviderUtil.key(accessKey, secretKey, options));
        if (null == client) {
            Region region = null;
            URL endpoint = null;
            String signer = null;
            if (options != null) {
                if (options.get(StorageAccount.OPTS.SWIFT_S3_ENDPOINT.name()) != null) {
                    try {
                        endpoint = new URL(options.get(StorageAccount.OPTS.SWIFT_S3_ENDPOINT.name()));
                    }
                    catch (MalformedURLException e) {
                        String err = "The provided Swift S3 Endpoint URL is invalid: " + e.getMessage();
                        throw new StorageException(err, e);
                    }
                    if (options.get(StorageAccount.OPTS.SWIFT_S3_SIGNER_TYPE.name()) != null) {
                        signer = options.get(StorageAccount.OPTS.SWIFT_S3_SIGNER_TYPE.name());
                    }
                } else if (options.get(StorageAccount.OPTS.AWS_REGION.name()) != null) {
                    region = com.amazonaws.services.s3.model.Region.fromValue(options.get(StorageAccount.OPTS.AWS_REGION.name())).toAWSRegion();
                }
            }
            client = S3ProviderUtil.newS3Client(accessKey, secretKey, region, endpoint, signer);
            s3Clients.put(S3ProviderUtil.key(accessKey, secretKey, options), client);
        }
        return client;
    }

    private static String key(String accessKey, String secretKey, Map<String, String> options) {
        String optionsHash = "";
        if (null != options && options.size() > 0) {
            optionsHash = Integer.toString(options.hashCode());
        }
        return accessKey + secretKey + optionsHash;
    }

    private static AmazonS3 newS3Client(String accessKey, String secretKey, Region region, URL endpoint, String signer) {
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(accessKey, secretKey);
        AmazonS3 s3Client = null;
        String awsRegion = null;
        try {
            if (endpoint == null) {
                awsRegion = region != null ? region.getName() : System.getProperty(StorageAccount.OPTS.AWS_REGION.name());
                log.debug("Creating AWS S3 Client.");
                s3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(new AWSStaticCredentialsProvider(awsCredentials))).withRegion(awsRegion)).build();
            } else {
                log.debug("Creating Swift S3 client.");
                String protocol = endpoint.getProtocol();
                String host = endpoint.getAuthority();
                String ref = endpoint.getRef();
                String endpointString = protocol + "://" + host;
                ClientConfiguration clientConfiguration = new ClientConfiguration();
                clientConfiguration.setProtocol(Protocol.valueOf(protocol.toUpperCase()));
                if (signer != null) {
                    clientConfiguration.setSignerOverride(signer);
                }
                awsRegion = ref == null ? "us-east-1" : ref;
                s3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpointString, awsRegion))).withPathStyleAccessEnabled(true)).withClientConfiguration(clientConfiguration)).withCredentials(new AWSStaticCredentialsProvider(awsCredentials))).build();
            }
            return s3Client;
        }
        catch (AmazonServiceException e) {
            String connType = endpoint == null ? "Amazon" : "Swift";
            String err = "Could not create connection to " + connType + " S3 due to error: " + e.getMessage();
            throw new StorageException(err, (Throwable)e, true);
        }
    }

    public static AmazonCloudFrontClient getAmazonCloudFrontClient(String accessKey, String secretKey) {
        AmazonCloudFrontClient client = cloudFrontClients.get(S3ProviderUtil.key(accessKey, secretKey, null));
        if (null == client) {
            client = S3ProviderUtil.newAmazonCloudFrontClient(accessKey, secretKey);
            cloudFrontClients.put(S3ProviderUtil.key(accessKey, secretKey, null), client);
        }
        return client;
    }

    private static AmazonCloudFrontClient newAmazonCloudFrontClient(String accessKey, String secretKey) {
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(accessKey, secretKey);
        try {
            return new AmazonCloudFrontClient(awsCredentials);
        }
        catch (AmazonServiceException e) {
            String err = "Could not create connection to Amazon CloudFront due to error: " + e.getMessage();
            throw new StorageException(err, (Throwable)e, true);
        }
    }

    public static String createNewBucketName(String accessKeyId, String spaceId) {
        Object bucketName = accessKeyId + "." + spaceId;
        bucketName = ((String)bucketName).toLowerCase();
        bucketName = ((String)bucketName).replaceAll("[^a-z0-9-.]", "-");
        while (((String)bucketName).contains("--") || ((String)bucketName).contains("..") || ((String)bucketName).contains("-.") || ((String)bucketName).contains(".-")) {
            bucketName = ((String)bucketName).replaceAll("[-]+", "-");
            bucketName = ((String)bucketName).replaceAll("[.]+", ".");
            bucketName = ((String)bucketName).replaceAll("-[.]", "-");
            bucketName = ((String)bucketName).replaceAll("[.]-", ".");
        }
        if (((String)bucketName).length() > 63) {
            bucketName = ((String)bucketName).substring(0, 63);
        }
        while (((String)bucketName).endsWith("-") || ((String)bucketName).endsWith(".")) {
            bucketName = ((String)bucketName).substring(0, ((String)bucketName).length() - 1);
        }
        return bucketName;
    }

    public static Resource getS3ObjectByUrl(String s3Url) throws IOException {
        AmazonS3 client = (AmazonS3)AmazonS3ClientBuilder.standard().build();
        AmazonS3URI s3Uri = new AmazonS3URI(s3Url);
        S3Object s3Obj = client.getObject(new GetObjectRequest(s3Uri.getBucket(), s3Uri.getKey()));
        s3Obj.getObjectContent();
        InputStreamResource resource = new InputStreamResource(s3Obj.getObjectContent());
        return resource;
    }
}

