/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudwatch.model.AnomalyDetectorConfiguration;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.Metric;
import com.amazonaws.services.cloudwatch.model.MetricDataQuery;
import com.amazonaws.services.cloudwatch.model.MetricMathAnomalyDetector;
import com.amazonaws.services.cloudwatch.model.MetricStat;
import com.amazonaws.services.cloudwatch.model.PutAnomalyDetectorRequest;
import com.amazonaws.services.cloudwatch.model.Range;
import com.amazonaws.services.cloudwatch.model.SingleMetricAnomalyDetector;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class PutAnomalyDetectorRequestMarshaller
implements Marshaller<Request<PutAnomalyDetectorRequest>, PutAnomalyDetectorRequest> {
    @Override
    public Request<PutAnomalyDetectorRequest> marshall(PutAnomalyDetectorRequest putAnomalyDetectorRequest) {
        MetricMathAnomalyDetector metricMathAnomalyDetector;
        SingleMetricAnomalyDetector singleMetricAnomalyDetector;
        AnomalyDetectorConfiguration configuration;
        if (putAnomalyDetectorRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutAnomalyDetectorRequest> request = new DefaultRequest<PutAnomalyDetectorRequest>(putAnomalyDetectorRequest, "AmazonCloudWatch");
        request.addParameter("Action", "PutAnomalyDetector");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putAnomalyDetectorRequest.getNamespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString(putAnomalyDetectorRequest.getNamespace()));
        }
        if (putAnomalyDetectorRequest.getMetricName() != null) {
            request.addParameter("MetricName", StringUtils.fromString(putAnomalyDetectorRequest.getMetricName()));
        }
        if (!putAnomalyDetectorRequest.getDimensions().isEmpty() || !((SdkInternalList)putAnomalyDetectorRequest.getDimensions()).isAutoConstruct()) {
            SdkInternalList dimensionsList = (SdkInternalList)putAnomalyDetectorRequest.getDimensions();
            int dimensionsListIndex = 1;
            for (Dimension dimensionsListValue : dimensionsList) {
                if (dimensionsListValue != null) {
                    if (dimensionsListValue.getName() != null) {
                        request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString(dimensionsListValue.getName()));
                    }
                    if (dimensionsListValue.getValue() != null) {
                        request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString(dimensionsListValue.getValue()));
                    }
                }
                ++dimensionsListIndex;
            }
        }
        if (putAnomalyDetectorRequest.getStat() != null) {
            request.addParameter("Stat", StringUtils.fromString(putAnomalyDetectorRequest.getStat()));
        }
        if ((configuration = putAnomalyDetectorRequest.getConfiguration()) != null) {
            if (!configuration.getExcludedTimeRanges().isEmpty() || !((SdkInternalList)configuration.getExcludedTimeRanges()).isAutoConstruct()) {
                SdkInternalList excludedTimeRangesList = (SdkInternalList)configuration.getExcludedTimeRanges();
                int excludedTimeRangesListIndex = 1;
                for (Range excludedTimeRangesListValue : excludedTimeRangesList) {
                    if (excludedTimeRangesListValue != null) {
                        if (excludedTimeRangesListValue.getStartTime() != null) {
                            request.addParameter("Configuration.ExcludedTimeRanges.member." + excludedTimeRangesListIndex + ".StartTime", StringUtils.fromDate(excludedTimeRangesListValue.getStartTime()));
                        }
                        if (excludedTimeRangesListValue.getEndTime() != null) {
                            request.addParameter("Configuration.ExcludedTimeRanges.member." + excludedTimeRangesListIndex + ".EndTime", StringUtils.fromDate(excludedTimeRangesListValue.getEndTime()));
                        }
                    }
                    ++excludedTimeRangesListIndex;
                }
            }
            if (configuration.getMetricTimezone() != null) {
                request.addParameter("Configuration.MetricTimezone", StringUtils.fromString(configuration.getMetricTimezone()));
            }
        }
        if ((singleMetricAnomalyDetector = putAnomalyDetectorRequest.getSingleMetricAnomalyDetector()) != null) {
            if (singleMetricAnomalyDetector.getNamespace() != null) {
                request.addParameter("SingleMetricAnomalyDetector.Namespace", StringUtils.fromString(singleMetricAnomalyDetector.getNamespace()));
            }
            if (singleMetricAnomalyDetector.getMetricName() != null) {
                request.addParameter("SingleMetricAnomalyDetector.MetricName", StringUtils.fromString(singleMetricAnomalyDetector.getMetricName()));
            }
            if (!singleMetricAnomalyDetector.getDimensions().isEmpty() || !((SdkInternalList)singleMetricAnomalyDetector.getDimensions()).isAutoConstruct()) {
                SdkInternalList dimensionsList = (SdkInternalList)singleMetricAnomalyDetector.getDimensions();
                int dimensionsListIndex = 1;
                for (Dimension dimensionsListValue : dimensionsList) {
                    if (dimensionsListValue != null) {
                        if (dimensionsListValue.getName() != null) {
                            request.addParameter("SingleMetricAnomalyDetector.Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString(dimensionsListValue.getName()));
                        }
                        if (dimensionsListValue.getValue() != null) {
                            request.addParameter("SingleMetricAnomalyDetector.Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString(dimensionsListValue.getValue()));
                        }
                    }
                    ++dimensionsListIndex;
                }
            }
            if (singleMetricAnomalyDetector.getStat() != null) {
                request.addParameter("SingleMetricAnomalyDetector.Stat", StringUtils.fromString(singleMetricAnomalyDetector.getStat()));
            }
        }
        if (!((metricMathAnomalyDetector = putAnomalyDetectorRequest.getMetricMathAnomalyDetector()) == null || metricMathAnomalyDetector.getMetricDataQueries().isEmpty() && ((SdkInternalList)metricMathAnomalyDetector.getMetricDataQueries()).isAutoConstruct())) {
            SdkInternalList metricDataQueriesList = (SdkInternalList)metricMathAnomalyDetector.getMetricDataQueries();
            int metricDataQueriesListIndex = 1;
            for (MetricDataQuery metricDataQueriesListValue : metricDataQueriesList) {
                if (metricDataQueriesListValue != null) {
                    MetricStat metricStat;
                    if (metricDataQueriesListValue.getId() != null) {
                        request.addParameter("MetricMathAnomalyDetector.MetricDataQueries.member." + metricDataQueriesListIndex + ".Id", StringUtils.fromString(metricDataQueriesListValue.getId()));
                    }
                    if ((metricStat = metricDataQueriesListValue.getMetricStat()) != null) {
                        Metric metric = metricStat.getMetric();
                        if (metric != null) {
                            if (metric.getNamespace() != null) {
                                request.addParameter("MetricMathAnomalyDetector.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.Namespace", StringUtils.fromString(metric.getNamespace()));
                            }
                            if (metric.getMetricName() != null) {
                                request.addParameter("MetricMathAnomalyDetector.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.MetricName", StringUtils.fromString(metric.getMetricName()));
                            }
                            if (!metric.getDimensions().isEmpty() || !((SdkInternalList)metric.getDimensions()).isAutoConstruct()) {
                                SdkInternalList dimensionsList = (SdkInternalList)metric.getDimensions();
                                int dimensionsListIndex = 1;
                                for (Dimension dimensionsListValue : dimensionsList) {
                                    if (dimensionsListValue != null) {
                                        if (dimensionsListValue.getName() != null) {
                                            request.addParameter("MetricMathAnomalyDetector.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString(dimensionsListValue.getName()));
                                        }
                                        if (dimensionsListValue.getValue() != null) {
                                            request.addParameter("MetricMathAnomalyDetector.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString(dimensionsListValue.getValue()));
                                        }
                                    }
                                    ++dimensionsListIndex;
                                }
                            }
                        }
                        if (metricStat.getPeriod() != null) {
                            request.addParameter("MetricMathAnomalyDetector.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Period", StringUtils.fromInteger(metricStat.getPeriod()));
                        }
                        if (metricStat.getStat() != null) {
                            request.addParameter("MetricMathAnomalyDetector.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Stat", StringUtils.fromString(metricStat.getStat()));
                        }
                        if (metricStat.getUnit() != null) {
                            request.addParameter("MetricMathAnomalyDetector.MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Unit", StringUtils.fromString(metricStat.getUnit()));
                        }
                    }
                    if (metricDataQueriesListValue.getExpression() != null) {
                        request.addParameter("MetricMathAnomalyDetector.MetricDataQueries.member." + metricDataQueriesListIndex + ".Expression", StringUtils.fromString(metricDataQueriesListValue.getExpression()));
                    }
                    if (metricDataQueriesListValue.getLabel() != null) {
                        request.addParameter("MetricMathAnomalyDetector.MetricDataQueries.member." + metricDataQueriesListIndex + ".Label", StringUtils.fromString(metricDataQueriesListValue.getLabel()));
                    }
                    if (metricDataQueriesListValue.getReturnData() != null) {
                        request.addParameter("MetricMathAnomalyDetector.MetricDataQueries.member." + metricDataQueriesListIndex + ".ReturnData", StringUtils.fromBoolean(metricDataQueriesListValue.getReturnData()));
                    }
                    if (metricDataQueriesListValue.getPeriod() != null) {
                        request.addParameter("MetricMathAnomalyDetector.MetricDataQueries.member." + metricDataQueriesListIndex + ".Period", StringUtils.fromInteger(metricDataQueriesListValue.getPeriod()));
                    }
                    if (metricDataQueriesListValue.getAccountId() != null) {
                        request.addParameter("MetricMathAnomalyDetector.MetricDataQueries.member." + metricDataQueriesListIndex + ".AccountId", StringUtils.fromString(metricDataQueriesListValue.getAccountId()));
                    }
                }
                ++metricDataQueriesListIndex;
            }
        }
        return request;
    }
}

