/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.audit;

import org.duracloud.audit.task.AuditTask;
import org.duracloud.mill.config.ConfigurationManager;
import org.duracloud.mill.notification.NotificationManager;
import org.duracloud.mill.workman.TaskExecutionFailedException;
import org.duracloud.mill.workman.TaskProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceCreatedNotifcationGeneratingProcessor
implements TaskProcessor {
    private static Logger log = LoggerFactory.getLogger(SpaceCreatedNotifcationGeneratingProcessor.class);
    private AuditTask task;
    private NotificationManager notificationManager;

    public SpaceCreatedNotifcationGeneratingProcessor(AuditTask task, NotificationManager notificationManager) {
        this.task = task;
        this.notificationManager = notificationManager;
    }

    @Override
    public void execute() throws TaskExecutionFailedException {
        if (AuditTask.ActionType.CREATE_SPACE.name().equals(this.task.getAction())) {
            String account = this.task.getAccount();
            log.info("new space audit task received for account {} received: {}", (Object)account, (Object)this.task);
            String storeId = this.task.getStoreId();
            String spaceId = this.task.getSpaceId();
            log.warn("New space notification: subdomain: {}, storeId: {}, spaceId: {}: ", account, storeId, spaceId);
            this.newSpace(account, this.task.getStoreId(), this.task.getSpaceId(), this.task.getDateTime(), this.task.getUserId());
        } else {
            log.debug("This task {} is not a space creation task: it will be ignored.", (Object)this.task);
        }
    }

    private void newSpace(String subdomain, String storeId, String spaceId, String datetime, String username) {
        ConfigurationManager configManager = new ConfigurationManager();
        String host = configManager.getSubdomainDotDefaultDomain(subdomain);
        String subject = "New Space on " + host + ", provider " + storeId + ": " + spaceId;
        StringBuilder body = new StringBuilder();
        body.append("A new space has been created!\n\n");
        body.append("Subdomain: https://" + host + "\n");
        body.append("Storage Provider Id: " + storeId + "\n");
        body.append("Space: " + spaceId + "\n");
        this.notificationManager.sendEmail(subject, body.toString());
    }
}

