/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.projection;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;

public class DefaultMethodInvokingMethodInterceptor
implements MethodInterceptor {
    private final MethodHandleLookup methodHandleLookup = MethodHandleLookup.getMethodHandleLookup();
    private final Map<Method, MethodHandle> methodHandleCache = new ConcurrentReferenceHashMap<Method, MethodHandle>(10, ConcurrentReferenceHashMap.ReferenceType.WEAK);

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (!org.springframework.data.util.ReflectionUtils.isDefaultMethod(method)) {
            return invocation.proceed();
        }
        Object[] arguments = invocation.getArguments();
        Object proxy = ((ProxyMethodInvocation)invocation).getProxy();
        return this.getMethodHandle(method).bindTo(proxy).invokeWithArguments(arguments);
    }

    private MethodHandle getMethodHandle(Method method) throws Exception {
        MethodHandle handle = this.methodHandleCache.get(method);
        if (handle == null) {
            handle = this.methodHandleLookup.lookup(method);
            this.methodHandleCache.put(method, handle);
        }
        return handle;
    }

    static enum MethodHandleLookup {
        OPEN{
            private final Constructor<MethodHandles.Lookup> constructor = MethodHandleLookup.access$100();

            @Override
            MethodHandle lookup(Method method) throws ReflectiveOperationException {
                if (this.constructor == null) {
                    throw new IllegalStateException("Could not obtain MethodHandles.lookup constructor");
                }
                return this.constructor.newInstance(method.getDeclaringClass()).unreflectSpecial(method, method.getDeclaringClass());
            }

            @Override
            boolean isAvailable() {
                return this.constructor != null;
            }
        }
        ,
        ENCAPSULATED{

            @Override
            MethodHandle lookup(Method method) throws ReflectiveOperationException {
                MethodType methodType = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
                return MethodHandles.lookup().findSpecial(method.getDeclaringClass(), method.getName(), methodType, method.getDeclaringClass());
            }

            @Override
            boolean isAvailable() {
                return true;
            }
        };


        abstract MethodHandle lookup(Method var1) throws ReflectiveOperationException;

        abstract boolean isAvailable();

        public static MethodHandleLookup getMethodHandleLookup() {
            for (MethodHandleLookup lookup : MethodHandleLookup.values()) {
                if (!lookup.isAvailable()) continue;
                return lookup;
            }
            throw new IllegalStateException("No MethodHandleLookup available!");
        }

        private static Constructor<MethodHandles.Lookup> getLookupConstructor() {
            try {
                Constructor<MethodHandles.Lookup> constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
                ReflectionUtils.makeAccessible(constructor);
                return constructor;
            }
            catch (Exception ex) {
                if (ex.getClass().getName().equals("java.lang.reflect.InaccessibleObjectException")) {
                    return null;
                }
                throw new IllegalStateException(ex);
            }
        }

        static /* synthetic */ Constructor access$100() {
            return MethodHandleLookup.getLookupConstructor();
        }
    }
}

