/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.services.cloudwatch.model.PartialFailure;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class PartialFailureStaxUnmarshaller
implements Unmarshaller<PartialFailure, StaxUnmarshallerContext> {
    private static PartialFailureStaxUnmarshaller instance;

    @Override
    public PartialFailure unmarshall(StaxUnmarshallerContext context) throws Exception {
        PartialFailure partialFailure = new PartialFailure();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return partialFailure;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("FailureResource", targetDepth)) {
                    partialFailure.setFailureResource(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ExceptionType", targetDepth)) {
                    partialFailure.setExceptionType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("FailureCode", targetDepth)) {
                    partialFailure.setFailureCode(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("FailureDescription", targetDepth)) continue;
                partialFailure.setFailureDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return partialFailure;
    }

    public static PartialFailureStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PartialFailureStaxUnmarshaller();
        }
        return instance;
    }
}

