/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.bit;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.duracloud.common.queue.TaskQueue;
import org.duracloud.common.retry.Retriable;
import org.duracloud.common.retry.Retrier;
import org.duracloud.common.util.DateUtil;
import org.duracloud.mill.bit.BitCheckExecutionState;
import org.duracloud.mill.bit.BitCheckHandler;
import org.duracloud.mill.bit.BitIntegrityCheckTask;
import org.duracloud.mill.bit.BitIntegrityCheckTaskExecutionFailedException;
import org.duracloud.mill.bit.BitIntegrityHelper;
import org.duracloud.mill.bit.ContentChecksumHelper;
import org.duracloud.mill.bit.HandlerResult;
import org.duracloud.mill.bitlog.BitIntegrityResult;
import org.duracloud.mill.bitlog.BitLogStore;
import org.duracloud.mill.db.model.ManifestItem;
import org.duracloud.mill.manifest.ManifestStore;
import org.duracloud.mill.workman.TaskExecutionFailedException;
import org.duracloud.mill.workman.TaskProcessorBase;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.error.NotFoundException;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitIntegrityCheckTaskProcessor
extends TaskProcessorBase {
    private static final Logger log = LoggerFactory.getLogger(BitIntegrityCheckTaskProcessor.class);
    private BitIntegrityCheckTask bitTask;
    private StorageProvider store;
    private ManifestStore manifestStore;
    private BitLogStore bitLogStore;
    private StorageProviderType storageProviderType;
    private TaskQueue bitErrorQueue;
    private TaskQueue auditTaskQueue;
    private static List<BitCheckHandler> HANDLERS = new LinkedList<BitCheckHandler>();
    private ContentChecksumHelper checksumHelper;
    private static long penultimateAttemptWaitMS = 300000L;

    public BitIntegrityCheckTaskProcessor(BitIntegrityCheckTask bitTask, StorageProvider store, ManifestStore manifestStore, StorageProviderType storageProviderType, BitLogStore bitLogStore, TaskQueue bitErrorQueue, TaskQueue auditTaskQueue, ContentChecksumHelper checksumHelper) {
        super(bitTask);
        this.bitTask = bitTask;
        this.store = store;
        this.storageProviderType = storageProviderType;
        this.bitLogStore = bitLogStore;
        this.bitErrorQueue = bitErrorQueue;
        this.auditTaskQueue = auditTaskQueue;
        this.manifestStore = manifestStore;
        this.checksumHelper = checksumHelper;
    }

    private static void initializeHandlers() {
        HANDLERS.add(new SuccessfulCheckHandler());
        HANDLERS.add(new SourContentHandler());
        HANDLERS.add(new FailedStorageProviderChecksumHandler());
        HANDLERS.add(new FailedManifestAndNoMatchesChecksumHandler());
        HANDLERS.add(new ContentNotFoundHandler());
        HANDLERS.add(new NoRecordOfItemHandler());
    }

    protected static void sleep() {
        try {
            Thread.sleep(penultimateAttemptWaitMS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    protected void executeImpl() throws TaskExecutionFailedException {
        BitCheckExecutionState state = new BitCheckExecutionState(this.bitTask, this.storageProviderType, this.bitLogStore, this.bitErrorQueue, this.auditTaskQueue, this.checksumHelper, this.manifestStore);
        Map<String, String> contentProperties = this.getContentProperties();
        state.setContentProperties(contentProperties);
        String storeChecksum = null;
        if (contentProperties != null) {
            storeChecksum = contentProperties.get("content-checksum");
        }
        state.setStoreChecksum(storeChecksum);
        String manifestChecksum = this.getManifestChecksum();
        state.setManifestChecksum(manifestChecksum);
        boolean handled = false;
        for (BitCheckHandler handler : this.getHandlers()) {
            if (!handler.handle(state)) continue;
            handled = true;
            break;
        }
        if (!handled) {
            throw new TaskExecutionFailedException("Nobody was able to handle the task this time around.");
        }
    }

    private String getManifestChecksum() {
        try {
            ManifestItem item = this.manifestStore.getItem(this.bitTask.getAccount(), this.bitTask.getStoreId(), this.bitTask.getSpaceId(), this.bitTask.getContentId());
            return item.getContentChecksum();
        }
        catch (org.duracloud.common.db.error.NotFoundException e) {
            return null;
        }
    }

    private List<BitCheckHandler> getHandlers() {
        return HANDLERS;
    }

    private Map<String, String> getContentProperties() throws TaskExecutionFailedException {
        try {
            return (Map)new Retrier().execute(new Retriable(){

                @Override
                public Map<String, String> retry() throws Exception {
                    return BitIntegrityCheckTaskProcessor.this.store.getContentProperties(BitIntegrityCheckTaskProcessor.this.bitTask.getSpaceId(), BitIntegrityCheckTaskProcessor.this.bitTask.getContentId());
                }
            });
        }
        catch (NotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new BitIntegrityCheckTaskExecutionFailedException(this.buildFailureMessage("Could not retrieve checksum from storage provider", this.bitTask, this.storageProviderType), e);
        }
    }

    private String buildFailureMessage(String message, BitIntegrityCheckTask bitTask, StorageProviderType storageProviderType) {
        return BitIntegrityHelper.buildFailureMessage(message, bitTask, storageProviderType);
    }

    public static void setPenultimateWaitMS(long milliseconds) {
        penultimateAttemptWaitMS = milliseconds;
    }

    static {
        BitIntegrityCheckTaskProcessor.initializeHandlers();
    }

    private static class SuccessfulCheckHandler
    extends BitCheckHandler {
        private SuccessfulCheckHandler() {
        }

        @Override
        protected HandlerResult handleImpl(BitCheckExecutionState state) throws TaskExecutionFailedException {
            String manifestChecksum = state.getManifestChecksum();
            String storeChecksum = state.getStoreChecksum();
            if (storeChecksum != null && storeChecksum.equals(manifestChecksum) && this.isContentChecksumOkay(state, manifestChecksum)) {
                return new HandlerResult(BitIntegrityResult.SUCCESS, null);
            }
            return new HandlerResult();
        }
    }

    private static class SourContentHandler
    extends BitCheckHandler {
        private SourContentHandler() {
        }

        @Override
        protected HandlerResult handleImpl(BitCheckExecutionState state) throws TaskExecutionFailedException {
            String contentChecksum;
            String manifestChecksum = state.getManifestChecksum();
            String storeChecksum = state.getStoreChecksum();
            StorageProviderType storageProviderType = state.getStorageProviderType();
            if (manifestChecksum != null && manifestChecksum.equals(storeChecksum) && this.isContentChecksumCalculated(storageProviderType) && !manifestChecksum.equals(contentChecksum = state.getContentChecksumHelper().getContentChecksum(manifestChecksum))) {
                String message = "Content appears to have gone sour: content checksum does not match the manifest and store";
                this.addErrorTask(state, message);
                return new HandlerResult(BitIntegrityResult.FAILURE, message);
            }
            return new HandlerResult();
        }
    }

    private static class FailedStorageProviderChecksumHandler
    extends BitCheckHandler {
        private FailedStorageProviderChecksumHandler() {
        }

        @Override
        protected HandlerResult handleImpl(BitCheckExecutionState state) throws TaskExecutionFailedException {
            String contentChecksum;
            String manifestChecksum = state.getManifestChecksum();
            String storeChecksum = state.getStoreChecksum();
            StorageProviderType storageProviderType = state.getStorageProviderType();
            if (manifestChecksum != null && storeChecksum != null && !manifestChecksum.equals(storeChecksum) && this.isContentChecksumCalculated(storageProviderType) && manifestChecksum.equals(contentChecksum = state.getContentChecksumHelper().getContentChecksum(manifestChecksum))) {
                if (this.isLastAttempt(state.getTask())) {
                    String message = "The storage provider's checksum did not match the others: the storage provider's checksumming process appears to have failed.";
                    this.addErrorTask(state, message);
                    return new HandlerResult(BitIntegrityResult.FAILURE, message);
                }
                if (this.isPenultimateAttempt(state.getTask())) {
                    BitIntegrityCheckTaskProcessor.sleep();
                }
            }
            return new HandlerResult();
        }
    }

    private static class FailedManifestAndNoMatchesChecksumHandler
    extends BitCheckHandler {
        private FailedManifestAndNoMatchesChecksumHandler() {
        }

        @Override
        protected HandlerResult handleImpl(BitCheckExecutionState state) throws TaskExecutionFailedException {
            String manifestChecksum = state.getManifestChecksum();
            String storeChecksum = state.getStoreChecksum();
            BitIntegrityCheckTask task = state.getTask();
            if (storeChecksum != null && !storeChecksum.equals(manifestChecksum)) {
                if (this.isLastAttempt(task)) {
                    Map<String, String> props = state.getContentProperties();
                    String modified = props.get("content-modified");
                    try {
                        Date modifiedDate = DateUtil.convertToDate(modified, DateUtil.DateFormat.DEFAULT_FORMAT);
                        Calendar c = Calendar.getInstance();
                        c.add(5, -1);
                        Date oneDayAgo = c.getTime();
                        if (modifiedDate.after(oneDayAgo)) {
                            String message = "The manifest entry's checksum (" + manifestChecksum + ") did not match the others: The content item is less than 1 day old. It is most likely that the item has not yet been processed by the mill. Therefore we are ignorning this content item for now.";
                            return new HandlerResult(BitIntegrityResult.IGNORE, message);
                        }
                    }
                    catch (ParseException e) {
                        throw new BitIntegrityCheckTaskExecutionFailedException("failed to parse date using DateFormat.DEFAULT_FORMAT: " + modified, e);
                    }
                    Object message = "The manifest checksum (" + manifestChecksum + ") did not match the others.";
                    if (!this.isContentChecksumOkay(state, storeChecksum)) {
                        message = MessageFormat.format("Neither the content checksum ({0}) nor the manifest checksum ({1})  match the store checksum ({2}).", state.getContentChecksumHelper().getContentChecksum(storeChecksum), manifestChecksum, storeChecksum);
                        log.error((String)message + ": storeId = {}, spaceId = {}, contentId = {}", task.getStoreId(), task.getSpaceId(), task.getContentId());
                    } else {
                        log.error((String)message + "{}", (Object)task);
                    }
                    this.updateManifestChecksum(state, storeChecksum);
                    this.addErrorTask(state, (String)message);
                    return new HandlerResult(BitIntegrityResult.FAILURE, (String)message);
                }
                if (this.isPenultimateAttempt(state.getTask())) {
                    BitIntegrityCheckTaskProcessor.sleep();
                }
            }
            return new HandlerResult();
        }

        private void updateManifestChecksum(BitCheckExecutionState state, String checksum) throws BitIntegrityCheckTaskExecutionFailedException {
            BitIntegrityCheckTask task = state.getTask();
            ManifestStore manifestStore = state.getManifestStore();
            String account = task.getAccount();
            String storeId = task.getStoreId();
            String spaceId = task.getSpaceId();
            String contentId = task.getContentId();
            try {
                String contentSize;
                String contentMimetype;
                try {
                    ManifestItem item = manifestStore.getItem(account, storeId, spaceId, contentId);
                    contentMimetype = item.getContentMimetype();
                    contentSize = item.getContentSize();
                }
                catch (org.duracloud.common.db.error.NotFoundException e) {
                    Map<String, String> props = state.getContentProperties();
                    contentMimetype = props.get("content-mimetype");
                    contentSize = props.get("content-size");
                }
                manifestStore.addUpdate(account, storeId, spaceId, contentId, checksum, contentMimetype, contentSize, new Date());
            }
            catch (Exception ex) {
                throw new BitIntegrityCheckTaskExecutionFailedException(this.buildFailureMessage("failed to update manifest: " + ex.getMessage(), task, state.getStorageProviderType()));
            }
        }
    }

    private static class ContentNotFoundHandler
    extends BitCheckHandler {
        private ContentNotFoundHandler() {
        }

        @Override
        protected HandlerResult handleImpl(BitCheckExecutionState state) throws TaskExecutionFailedException {
            String storeChecksum = state.getStoreChecksum();
            String manifestChecksum = state.getManifestChecksum();
            StorageProviderType storageProviderType = state.getStorageProviderType();
            BitIntegrityCheckTask task = state.getTask();
            if (storeChecksum == null && manifestChecksum != null) {
                Object message = "The item is not in the Storage Provider, but is in the manifest. ";
                if (!this.isLastAttempt(task)) {
                    if (this.isPenultimateAttempt(task)) {
                        log.warn(this.buildFailureMessage((String)message + "It is possible that content added audit tasks have not propagated through the mill. Waiting a few minutes before making final attempt.", task, storageProviderType));
                        BitIntegrityCheckTaskProcessor.sleep();
                    }
                } else {
                    message = (String)message + "  Is the audit queue overloaded? Perhaps a delete event got dropped?";
                    this.addErrorTask(state, (String)message);
                    return new HandlerResult(BitIntegrityResult.FAILURE, (String)message);
                }
            }
            return new HandlerResult();
        }
    }

    private static class NoRecordOfItemHandler
    extends BitCheckHandler {
        private NoRecordOfItemHandler() {
        }

        @Override
        protected HandlerResult handleImpl(BitCheckExecutionState state) {
            String storeChecksum = state.getStoreChecksum();
            String manifestChecksum = state.getManifestChecksum();
            StorageProviderType storageProviderType = state.getStorageProviderType();
            if (storeChecksum == null && manifestChecksum == null) {
                String message = "No matching checksums for this content item could be found.  This bit integrity task is likely being processed after a deletion has been fully processed by duracloud. Ignoring...";
                log.warn(this.buildFailureMessage(message, state.getTask(), storageProviderType));
                return new HandlerResult(BitIntegrityResult.IGNORE, null);
            }
            return new HandlerResult();
        }
    }
}

