/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshottask.snapshot;

import java.io.IOException;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.duracloud.common.util.DateUtil;
import org.duracloud.common.web.RestHttpHelper;
import org.duracloud.snapshot.dto.bridge.CreateSnapshotBridgeParameters;
import org.duracloud.snapshot.dto.bridge.CreateSnapshotBridgeResult;
import org.duracloud.snapshot.dto.task.CreateSnapshotTaskParameters;
import org.duracloud.snapshot.id.SnapshotIdentifier;
import org.duracloud.snapshotstorage.SnapshotStorageProvider;
import org.duracloud.snapshottask.snapshot.SpaceModifyingSnapshotTaskRunner;
import org.duracloud.storage.error.ServerConflictException;
import org.duracloud.storage.error.StorageStateException;
import org.duracloud.storage.error.TaskException;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSnapshotTaskRunner
extends SpaceModifyingSnapshotTaskRunner {
    private Logger log = LoggerFactory.getLogger(CreateSnapshotTaskRunner.class);
    private String dcAccountName;
    private String dcHost;
    private String dcPort;
    private String dcStoreId;
    private String bridgeMemberId;

    public CreateSnapshotTaskRunner(StorageProvider snapshotProvider, SnapshotStorageProvider unwrappedSnapshotProvider, String dcHost, String dcPort, String dcStoreId, String dcAccountName, String dcSnapshotUser, String bridgeAppHost, String bridgeAppPort, String bridgeAppUser, String bridgeAppPass, String bridgeMemberId) {
        super(snapshotProvider, unwrappedSnapshotProvider, dcSnapshotUser, bridgeAppHost, bridgeAppPort, bridgeAppUser, bridgeAppPass);
        this.dcHost = dcHost;
        this.dcPort = dcPort;
        this.dcStoreId = dcStoreId;
        this.dcAccountName = dcAccountName;
        this.bridgeMemberId = bridgeMemberId;
    }

    @Override
    public String getName() {
        return "create-snapshot";
    }

    @Override
    public String performTask(String taskParameters) {
        String callResult;
        this.log.info("Performing SNAPSHOT task with parameters, DuraCloud Host: {} DuraCloud Port: {} DuraCloud StoreID: {} Account Name: {} DuraCloud Snapshot User: {} Bridge Host: {} Bridge Port: {} Bridge User: {} Member Id: {}", this.dcHost, this.dcPort, this.dcStoreId, this.dcAccountName, this.getSnapshotUser(), this.getBridgeAppHost(), this.getBridgeAppPort(), this.getBridgeAppUser(), this.bridgeMemberId);
        CreateSnapshotTaskParameters taskParams = CreateSnapshotTaskParameters.deserialize(taskParameters);
        String spaceId = taskParams.getSpaceId();
        String snapshotId = this.getSnapshotIdFromProperties(spaceId);
        if (snapshotId != null) {
            throw new StorageStateException(MessageFormat.format("A snapshot ({0}) + is already underway for this space ({1})", snapshotId, spaceId), null);
        }
        long now = System.currentTimeMillis();
        snapshotId = this.generateSnapshotId(spaceId, now);
        HashMap<String, String> snapshotProps = new HashMap<String, String>();
        snapshotProps.put("duracloud-host", this.dcHost);
        snapshotProps.put("duracloud-space-id", spaceId);
        snapshotProps.put("duracloud-store-id", this.dcStoreId);
        snapshotProps.put("snapshot-id", snapshotId);
        snapshotProps.put("snapshot-date", DateUtil.convertToStringVerbose(now));
        snapshotProps.put("owner-id", this.dcAccountName);
        snapshotProps.put("description", taskParams.getDescription());
        snapshotProps.put("user-email", taskParams.getUserEmail());
        snapshotProps.put("member-id", this.bridgeMemberId);
        String serializedProps = this.buildSnapshotProps(snapshotProps);
        this.storeSnapshotProps(spaceId, serializedProps);
        this.addSnapshotIdToSpaceProps(spaceId, snapshotId);
        this.setSnapshotUserPermissions(spaceId);
        String snapshotURL = this.buildSnapshotURL(snapshotId);
        RestHttpHelper restHelper = this.createRestHelper();
        try {
            String snapshotBody = this.buildSnapshotBody(taskParams);
            callResult = this.callBridge(restHelper, snapshotURL, snapshotBody);
        }
        catch (Exception e) {
            this.log.error("Call to Bridge to create snapshot {} failed due to: {}", (Object)snapshotId, (Object)e.getMessage());
            this.wait(7);
            if (this.snapshotExists(restHelper, snapshotURL)) {
                this.log.info("Create snapshot call appeared to fail, but snapshot exists. Cleanup is being skipped to avoid removing files from an active snapshot.");
            } else {
                try {
                    this.removeSnapshotProps(spaceId);
                    this.removeSnapshotIdFromSpaceProps(spaceId);
                }
                catch (Exception ex) {
                    this.log.error("Failed to fully clean up snapshot props for " + spaceId + ": " + ex.getMessage(), ex);
                }
            }
            if (!(e instanceof TaskException)) {
                throw new TaskException(e.getMessage());
            }
            throw (TaskException)e;
        }
        CreateSnapshotBridgeResult bridgeResult = CreateSnapshotBridgeResult.deserialize(callResult);
        this.log.info("SNAPSHOT created with ID {} and status {}", (Object)bridgeResult.getSnapshotId(), (Object)bridgeResult.getStatus());
        return callResult;
    }

    protected String generateSnapshotId(String spaceId, long timestamp) {
        SnapshotIdentifier snapshotIdentifier = new SnapshotIdentifier(this.dcAccountName, this.dcStoreId, spaceId, timestamp);
        return snapshotIdentifier.getSnapshotId();
    }

    protected String buildSnapshotURL(String snapshotId) {
        return MessageFormat.format("{0}/snapshot/{1}", this.buildBridgeBaseURL(), snapshotId);
    }

    protected String buildSnapshotBody(CreateSnapshotTaskParameters taskParams) {
        CreateSnapshotBridgeParameters bridgeParams = new CreateSnapshotBridgeParameters(this.dcHost, this.dcPort, this.dcStoreId, taskParams.getSpaceId(), taskParams.getDescription(), taskParams.getUserEmail(), this.bridgeMemberId);
        return bridgeParams.serialize();
    }

    protected String buildSnapshotProps(Map<String, String> props) {
        Properties snapshotProperties = new Properties();
        for (String key : props.keySet()) {
            snapshotProperties.setProperty(key, props.get(key));
        }
        StringWriter writer = new StringWriter();
        try {
            snapshotProperties.store(writer, null);
        }
        catch (IOException e) {
            throw new TaskException("Could not write snapshot properties: " + e.getMessage(), e);
        }
        writer.flush();
        return writer.toString();
    }

    protected String callBridge(RestHttpHelper restHelper, String snapshotURL, String snapshotBody) throws Exception {
        this.log.info("Making Create SNAPSHOT call to URL {} with body {}", (Object)snapshotURL, (Object)snapshotBody);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        RestHttpHelper.HttpResponse response = restHelper.put(snapshotURL, snapshotBody, headers);
        int statusCode = response.getStatusCode();
        if (statusCode != 200 && statusCode != 201) {
            String responseStr = response.getResponseBody();
            this.log.warn("Create SNAPSHOT call returned an unexpected result, code: {}, body: {}", (Object)statusCode, (Object)responseStr);
            try {
                String m = this.getMessageValue(responseStr);
                if (m != null) {
                    responseStr = m;
                }
            }
            catch (IOException ex) {
                this.log.warn(ex.getMessage(), ex);
            }
            if (statusCode == 409) {
                throw new ServerConflictException(responseStr);
            }
            throw new RuntimeException(responseStr + " (" + statusCode + ")");
        }
        return response.getResponseBody();
    }

    protected boolean snapshotExists(RestHttpHelper restHelper, String snapshotURL) {
        this.log.info("Making Get SNAPSHOT call to URL {}", (Object)snapshotURL);
        try {
            RestHttpHelper.HttpResponse response = restHelper.get(snapshotURL);
            int statusCode = response.getStatusCode();
            if (statusCode != 200) {
                this.log.info("Get SNAPSHOT call returned a non-200 result code: {}", (Object)statusCode);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

