/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.projection;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.Jsr310Converters;
import org.springframework.data.projection.DefaultMethodInvokingMethodInterceptor;
import org.springframework.data.projection.DefaultProjectionInformation;
import org.springframework.data.projection.MapAccessingMethodInterceptor;
import org.springframework.data.projection.MethodInterceptorFactory;
import org.springframework.data.projection.ProjectingMethodInterceptor;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.ProjectionInformation;
import org.springframework.data.projection.PropertyAccessingMethodInterceptor;
import org.springframework.data.projection.TargetAware;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.NullableWrapperConverters;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;

class ProxyProjectionFactory
implements ProjectionFactory,
BeanClassLoaderAware {
    static final GenericConversionService CONVERSION_SERVICE = new DefaultConversionService();
    private final List<MethodInterceptorFactory> factories;
    private final Map<Class<?>, ProjectionMetadata> projectionInformationCache = new ConcurrentReferenceHashMap();
    @Nullable
    private ClassLoader classLoader;
    private final Lazy<DefaultMethodInvokingMethodInterceptor> defaultMethodInvokingMethodInterceptor = Lazy.of(DefaultMethodInvokingMethodInterceptor::new);

    protected ProxyProjectionFactory() {
        this.factories = new ArrayList<MethodInterceptorFactory>();
        this.factories.add(MapAccessingMethodInterceptorFactory.INSTANCE);
        this.factories.add(PropertyAccessingMethodInvokerFactory.INSTANCE);
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void registerMethodInvokerFactory(MethodInterceptorFactory factory) {
        Assert.notNull((Object)factory, "MethodInterceptorFactory must not be null");
        this.factories.add(0, factory);
    }

    @Override
    public <T> T createProjection(Class<T> projectionType, Object source) {
        Assert.notNull(projectionType, "Projection type must not be null");
        Assert.notNull(source, "Source must not be null");
        Assert.isTrue(projectionType.isInterface(), "Projection type must be an interface");
        if (projectionType.isInstance(source)) {
            return (T)source;
        }
        ProxyFactory factory = new ProxyFactory();
        factory.setTarget(source);
        factory.setOpaque(true);
        factory.setInterfaces(projectionType, TargetAware.class);
        ProjectionMetadata projectionMetadata = this.getProjectionMetadata(projectionType);
        if (projectionMetadata.hasDefaultMethods) {
            factory.addAdvice(this.defaultMethodInvokingMethodInterceptor.get());
        }
        factory.addAdvice(new TargetAwareMethodInterceptor(source.getClass()));
        factory.addAdvice(this.getMethodInterceptor(source, projectionType));
        return (T)factory.getProxy(this.classLoader == null ? ClassUtils.getDefaultClassLoader() : this.classLoader);
    }

    @Override
    public <T> T createProjection(Class<T> projectionType) {
        Assert.notNull(projectionType, "Projection type must not be null");
        return this.createProjection(projectionType, new HashMap());
    }

    @Override
    public final ProjectionInformation getProjectionInformation(Class<?> projectionType) {
        return this.getProjectionMetadata(projectionType).projectionInformation;
    }

    private ProjectionMetadata getProjectionMetadata(Class<?> projectionType) {
        return this.projectionInformationCache.computeIfAbsent(projectionType, it -> ProjectionMetadata.create(it, this.createProjectionInformation((Class<?>)it)));
    }

    protected MethodInterceptor postProcessAccessorInterceptor(MethodInterceptor interceptor, Object source, Class<?> projectionType) {
        return interceptor;
    }

    protected ProjectionInformation createProjectionInformation(Class<?> projectionType) {
        return new DefaultProjectionInformation(projectionType);
    }

    private MethodInterceptor getMethodInterceptor(Object source, Class<?> projectionType) {
        MethodInterceptor propertyInvocationInterceptor = this.getFactoryFor(source, projectionType).createMethodInterceptor(source, projectionType);
        return new ProjectingMethodInterceptor(this, this.postProcessAccessorInterceptor(propertyInvocationInterceptor, source, projectionType), CONVERSION_SERVICE);
    }

    private MethodInterceptorFactory getFactoryFor(Object source, Class<?> projectionType) {
        for (MethodInterceptorFactory factory : this.factories) {
            if (!factory.supports(source, projectionType)) continue;
            return factory;
        }
        throw new IllegalStateException("No MethodInterceptorFactory found for type ".concat(source.getClass().getName()));
    }

    static {
        Jsr310Converters.getConvertersToRegister().forEach(CONVERSION_SERVICE::addConverter);
        NullableWrapperConverters.registerConvertersIn(CONVERSION_SERVICE);
        CONVERSION_SERVICE.removeConvertible(Object.class, Object.class);
    }

    static class ProjectionMetadata {
        final boolean hasDefaultMethods;
        final ProjectionInformation projectionInformation;

        ProjectionMetadata(boolean hasDefaultMethods, ProjectionInformation projectionInformation) {
            this.hasDefaultMethods = hasDefaultMethods;
            this.projectionInformation = projectionInformation;
        }

        public static ProjectionMetadata create(Class<?> projectionType, ProjectionInformation projectionInformation) {
            return new ProjectionMetadata(DefaultMethodInvokingMethodInterceptor.hasDefaultMethods(projectionType), projectionInformation);
        }
    }

    private static enum PropertyAccessingMethodInvokerFactory implements MethodInterceptorFactory
    {
        INSTANCE;


        @Override
        public MethodInterceptor createMethodInterceptor(Object source, Class<?> targetType) {
            return new PropertyAccessingMethodInterceptor(source);
        }

        @Override
        public boolean supports(Object source, Class<?> targetType) {
            return true;
        }
    }

    private static enum MapAccessingMethodInterceptorFactory implements MethodInterceptorFactory
    {
        INSTANCE;


        @Override
        public MethodInterceptor createMethodInterceptor(Object source, Class<?> targetType) {
            return new MapAccessingMethodInterceptor((Map)source);
        }

        @Override
        public boolean supports(Object source, Class<?> targetType) {
            return Map.class.isInstance(source);
        }
    }

    private static class TargetAwareMethodInterceptor
    implements MethodInterceptor {
        private static final Method GET_TARGET_CLASS_METHOD;
        private static final Method GET_TARGET_METHOD;
        private final Class<?> targetType;

        public TargetAwareMethodInterceptor(Class<?> targetType) {
            Assert.notNull(targetType, "Target type must not be null");
            this.targetType = targetType;
        }

        @Override
        @Nullable
        public Object invoke(MethodInvocation invocation) throws Throwable {
            if (invocation.getMethod().equals(GET_TARGET_CLASS_METHOD)) {
                return this.targetType;
            }
            if (invocation.getMethod().equals(GET_TARGET_METHOD)) {
                return invocation.getThis();
            }
            return invocation.proceed();
        }

        static {
            try {
                GET_TARGET_CLASS_METHOD = TargetAware.class.getMethod("getTargetClass", new Class[0]);
                GET_TARGET_METHOD = TargetAware.class.getMethod("getTarget", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

