/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudfront.model.ContinuousDeploymentPolicyConfig;
import com.amazonaws.services.cloudfront.model.ContinuousDeploymentSingleHeaderConfig;
import com.amazonaws.services.cloudfront.model.ContinuousDeploymentSingleWeightConfig;
import com.amazonaws.services.cloudfront.model.CreateContinuousDeploymentPolicyRequest;
import com.amazonaws.services.cloudfront.model.SessionStickinessConfig;
import com.amazonaws.services.cloudfront.model.StagingDistributionDnsNames;
import com.amazonaws.services.cloudfront.model.TrafficConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;

public class CreateContinuousDeploymentPolicyRequestMarshaller
implements Marshaller<Request<CreateContinuousDeploymentPolicyRequest>, CreateContinuousDeploymentPolicyRequest> {
    @Override
    public Request<CreateContinuousDeploymentPolicyRequest> marshall(CreateContinuousDeploymentPolicyRequest createContinuousDeploymentPolicyRequest) {
        if (createContinuousDeploymentPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateContinuousDeploymentPolicyRequest> request = new DefaultRequest<CreateContinuousDeploymentPolicyRequest>(createContinuousDeploymentPolicyRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2020-05-31/continuous-deployment-policy";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(stringWriter, "http://cloudfront.amazonaws.com/doc/2020-05-31/");
            ContinuousDeploymentPolicyConfig continuousDeploymentPolicyConfig = createContinuousDeploymentPolicyRequest.getContinuousDeploymentPolicyConfig();
            if (continuousDeploymentPolicyConfig != null) {
                TrafficConfig trafficConfig;
                xmlWriter.startElement("ContinuousDeploymentPolicyConfig");
                StagingDistributionDnsNames stagingDistributionDnsNames = continuousDeploymentPolicyConfig.getStagingDistributionDnsNames();
                if (stagingDistributionDnsNames != null) {
                    SdkInternalList stagingDistributionDnsNamesItemsList;
                    xmlWriter.startElement("StagingDistributionDnsNames");
                    if (stagingDistributionDnsNames.getQuantity() != null) {
                        xmlWriter.startElement("Quantity").value(stagingDistributionDnsNames.getQuantity()).endElement();
                    }
                    if (!(stagingDistributionDnsNamesItemsList = (SdkInternalList)stagingDistributionDnsNames.getItems()).isEmpty() || !stagingDistributionDnsNamesItemsList.isAutoConstruct()) {
                        xmlWriter.startElement("Items");
                        for (String stagingDistributionDnsNamesItemsListValue : stagingDistributionDnsNamesItemsList) {
                            xmlWriter.startElement("DnsName");
                            xmlWriter.value(stagingDistributionDnsNamesItemsListValue);
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (continuousDeploymentPolicyConfig.getEnabled() != null) {
                    xmlWriter.startElement("Enabled").value(continuousDeploymentPolicyConfig.getEnabled()).endElement();
                }
                if ((trafficConfig = continuousDeploymentPolicyConfig.getTrafficConfig()) != null) {
                    ContinuousDeploymentSingleHeaderConfig singleHeaderConfig;
                    xmlWriter.startElement("TrafficConfig");
                    ContinuousDeploymentSingleWeightConfig singleWeightConfig = trafficConfig.getSingleWeightConfig();
                    if (singleWeightConfig != null) {
                        SessionStickinessConfig sessionStickinessConfig;
                        xmlWriter.startElement("SingleWeightConfig");
                        if (singleWeightConfig.getWeight() != null) {
                            xmlWriter.startElement("Weight").value(singleWeightConfig.getWeight()).endElement();
                        }
                        if ((sessionStickinessConfig = singleWeightConfig.getSessionStickinessConfig()) != null) {
                            xmlWriter.startElement("SessionStickinessConfig");
                            if (sessionStickinessConfig.getIdleTTL() != null) {
                                xmlWriter.startElement("IdleTTL").value(sessionStickinessConfig.getIdleTTL()).endElement();
                            }
                            if (sessionStickinessConfig.getMaximumTTL() != null) {
                                xmlWriter.startElement("MaximumTTL").value(sessionStickinessConfig.getMaximumTTL()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((singleHeaderConfig = trafficConfig.getSingleHeaderConfig()) != null) {
                        xmlWriter.startElement("SingleHeaderConfig");
                        if (singleHeaderConfig.getHeader() != null) {
                            xmlWriter.startElement("Header").value(singleHeaderConfig.getHeader()).endElement();
                        }
                        if (singleHeaderConfig.getValue() != null) {
                            xmlWriter.startElement("Value").value(singleHeaderConfig.getValue()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (trafficConfig.getType() != null) {
                        xmlWriter.startElement("Type").value(trafficConfig.getType()).endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

