/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.workman.spring;

import java.util.Arrays;
import java.util.List;
import org.duracloud.mill.common.taskproducer.TaskProducerConfigurationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkmanConfigurationManager
extends TaskProducerConfigurationManager {
    private static Logger log = LoggerFactory.getLogger(WorkmanConfigurationManager.class);

    public String getDeadLetterQueueName() {
        return System.getProperty("queue.name.dead-letter");
    }

    public List<String> getTaskQueueNames() {
        List<String> queueNames = Arrays.asList(System.getProperty("queue.task.ordered").split(","));
        for (int i = 0; i < queueNames.size(); ++i) {
            String key = queueNames.get(i);
            String value = System.getProperty(key.trim());
            log.info("Resolved concrete queue name from key : {}={}", (Object)key, (Object)value);
            queueNames.set(i, value);
        }
        return queueNames;
    }

    public String getPolicyBucketSuffix() {
        return System.getProperty("duplication-policy.bucket-suffix");
    }

    public Long getPolicyManagerRefreshFrequencyMs() {
        String refresh = System.getProperty("duplication-policy.refresh-frequency");
        if (refresh != null) {
            return Long.valueOf(refresh);
        }
        return 300000L;
    }

    public String getHighPriorityDuplicationQueueName() {
        return System.getProperty("queue.name.dup-high-priority");
    }

    public String getBitErrorQueueName() {
        return System.getProperty("queue.name.bit-error");
    }
}

