/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudfront.model.CreateRealtimeLogConfigRequest;
import com.amazonaws.services.cloudfront.model.EndPoint;
import com.amazonaws.services.cloudfront.model.KinesisStreamConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;

public class CreateRealtimeLogConfigRequestMarshaller
implements Marshaller<Request<CreateRealtimeLogConfigRequest>, CreateRealtimeLogConfigRequest> {
    @Override
    public Request<CreateRealtimeLogConfigRequest> marshall(CreateRealtimeLogConfigRequest createRealtimeLogConfigRequest) {
        if (createRealtimeLogConfigRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateRealtimeLogConfigRequest> request = new DefaultRequest<CreateRealtimeLogConfigRequest>(createRealtimeLogConfigRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2020-05-31/realtime-log-config";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(stringWriter, "http://cloudfront.amazonaws.com/doc/2020-05-31/");
            xmlWriter.startElement("CreateRealtimeLogConfigRequest");
            if (createRealtimeLogConfigRequest != null) {
                SdkInternalList createRealtimeLogConfigRequestFieldsList;
                SdkInternalList createRealtimeLogConfigRequestEndPointsList = (SdkInternalList)createRealtimeLogConfigRequest.getEndPoints();
                if (!createRealtimeLogConfigRequestEndPointsList.isEmpty() || !createRealtimeLogConfigRequestEndPointsList.isAutoConstruct()) {
                    xmlWriter.startElement("EndPoints");
                    for (EndPoint createRealtimeLogConfigRequestEndPointsListValue : createRealtimeLogConfigRequestEndPointsList) {
                        KinesisStreamConfig kinesisStreamConfig;
                        xmlWriter.startElement("member");
                        if (createRealtimeLogConfigRequestEndPointsListValue.getStreamType() != null) {
                            xmlWriter.startElement("StreamType").value(createRealtimeLogConfigRequestEndPointsListValue.getStreamType()).endElement();
                        }
                        if ((kinesisStreamConfig = createRealtimeLogConfigRequestEndPointsListValue.getKinesisStreamConfig()) != null) {
                            xmlWriter.startElement("KinesisStreamConfig");
                            if (kinesisStreamConfig.getRoleARN() != null) {
                                xmlWriter.startElement("RoleARN").value(kinesisStreamConfig.getRoleARN()).endElement();
                            }
                            if (kinesisStreamConfig.getStreamARN() != null) {
                                xmlWriter.startElement("StreamARN").value(kinesisStreamConfig.getStreamARN()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (!(createRealtimeLogConfigRequestFieldsList = (SdkInternalList)createRealtimeLogConfigRequest.getFields()).isEmpty() || !createRealtimeLogConfigRequestFieldsList.isAutoConstruct()) {
                    xmlWriter.startElement("Fields");
                    for (String createRealtimeLogConfigRequestFieldsListValue : createRealtimeLogConfigRequestFieldsList) {
                        xmlWriter.startElement("Field");
                        xmlWriter.value(createRealtimeLogConfigRequestFieldsListValue);
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (createRealtimeLogConfigRequest.getName() != null) {
                    xmlWriter.startElement("Name").value(createRealtimeLogConfigRequest.getName()).endElement();
                }
                if (createRealtimeLogConfigRequest.getSamplingRate() != null) {
                    xmlWriter.startElement("SamplingRate").value(createRealtimeLogConfigRequest.getSamplingRate()).endElement();
                }
            }
            xmlWriter.endElement();
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

