/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.DeleteFunctionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;

public class DeleteFunctionRequestMarshaller
implements Marshaller<Request<DeleteFunctionRequest>, DeleteFunctionRequest> {
    @Override
    public Request<DeleteFunctionRequest> marshall(DeleteFunctionRequest deleteFunctionRequest) {
        if (deleteFunctionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteFunctionRequest> request = new DefaultRequest<DeleteFunctionRequest>(deleteFunctionRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (deleteFunctionRequest.getIfMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString(deleteFunctionRequest.getIfMatch()));
        }
        String uriResourcePath = "/2020-05-31/function/{Name}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Name", deleteFunctionRequest.getName());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

