/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.DescribeFunctionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;

public class DescribeFunctionRequestMarshaller
implements Marshaller<Request<DescribeFunctionRequest>, DescribeFunctionRequest> {
    @Override
    public Request<DescribeFunctionRequest> marshall(DescribeFunctionRequest describeFunctionRequest) {
        if (describeFunctionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeFunctionRequest> request = new DefaultRequest<DescribeFunctionRequest>(describeFunctionRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2020-05-31/function/{Name}/describe";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Name", describeFunctionRequest.getName());
        request.setResourcePath(uriResourcePath);
        if (describeFunctionRequest.getStage() != null) {
            request.addParameter("Stage", StringUtils.fromString(describeFunctionRequest.getStage()));
        }
        return request;
    }
}

