/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.KeyValueStore;
import com.amazonaws.services.cloudfront.model.KeyValueStoreList;
import com.amazonaws.services.cloudfront.model.transform.KeyValueStoreStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class KeyValueStoreListStaxUnmarshaller
implements Unmarshaller<KeyValueStoreList, StaxUnmarshallerContext> {
    private static KeyValueStoreListStaxUnmarshaller instance;

    @Override
    public KeyValueStoreList unmarshall(StaxUnmarshallerContext context) throws Exception {
        KeyValueStoreList keyValueStoreList = new KeyValueStoreList();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return keyValueStoreList;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("NextMarker", targetDepth)) {
                    keyValueStoreList.setNextMarker(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MaxItems", targetDepth)) {
                    keyValueStoreList.setMaxItems(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Quantity", targetDepth)) {
                    keyValueStoreList.setQuantity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    keyValueStoreList.withItems(new ArrayList<KeyValueStore>());
                    continue;
                }
                if (!context.testExpression("Items/KeyValueStore", targetDepth)) continue;
                keyValueStoreList.withItems(KeyValueStoreStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return keyValueStoreList;
    }

    public static KeyValueStoreListStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new KeyValueStoreListStaxUnmarshaller();
        }
        return instance;
    }
}

