/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.UpdateKeyValueStoreRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;

public class UpdateKeyValueStoreRequestMarshaller
implements Marshaller<Request<UpdateKeyValueStoreRequest>, UpdateKeyValueStoreRequest> {
    @Override
    public Request<UpdateKeyValueStoreRequest> marshall(UpdateKeyValueStoreRequest updateKeyValueStoreRequest) {
        if (updateKeyValueStoreRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateKeyValueStoreRequest> request = new DefaultRequest<UpdateKeyValueStoreRequest>(updateKeyValueStoreRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.PUT);
        if (updateKeyValueStoreRequest.getIfMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString(updateKeyValueStoreRequest.getIfMatch()));
        }
        String uriResourcePath = "/2020-05-31/key-value-store/{Name}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Name", updateKeyValueStoreRequest.getName());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(stringWriter, "http://cloudfront.amazonaws.com/doc/2020-05-31/");
            xmlWriter.startElement("UpdateKeyValueStoreRequest");
            if (updateKeyValueStoreRequest != null && updateKeyValueStoreRequest.getComment() != null) {
                xmlWriter.startElement("Comment").value(updateKeyValueStoreRequest.getComment()).endElement();
            }
            xmlWriter.endElement();
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

