/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.OriginAccessControlConfig;
import com.amazonaws.services.cloudfront.model.UpdateOriginAccessControlRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;

public class UpdateOriginAccessControlRequestMarshaller
implements Marshaller<Request<UpdateOriginAccessControlRequest>, UpdateOriginAccessControlRequest> {
    @Override
    public Request<UpdateOriginAccessControlRequest> marshall(UpdateOriginAccessControlRequest updateOriginAccessControlRequest) {
        if (updateOriginAccessControlRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateOriginAccessControlRequest> request = new DefaultRequest<UpdateOriginAccessControlRequest>(updateOriginAccessControlRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.PUT);
        if (updateOriginAccessControlRequest.getIfMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString(updateOriginAccessControlRequest.getIfMatch()));
        }
        String uriResourcePath = "/2020-05-31/origin-access-control/{Id}/config";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Id", updateOriginAccessControlRequest.getId());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(stringWriter, "http://cloudfront.amazonaws.com/doc/2020-05-31/");
            OriginAccessControlConfig originAccessControlConfig = updateOriginAccessControlRequest.getOriginAccessControlConfig();
            if (originAccessControlConfig != null) {
                xmlWriter.startElement("OriginAccessControlConfig");
                if (originAccessControlConfig.getName() != null) {
                    xmlWriter.startElement("Name").value(originAccessControlConfig.getName()).endElement();
                }
                if (originAccessControlConfig.getDescription() != null) {
                    xmlWriter.startElement("Description").value(originAccessControlConfig.getDescription()).endElement();
                }
                if (originAccessControlConfig.getSigningProtocol() != null) {
                    xmlWriter.startElement("SigningProtocol").value(originAccessControlConfig.getSigningProtocol()).endElement();
                }
                if (originAccessControlConfig.getSigningBehavior() != null) {
                    xmlWriter.startElement("SigningBehavior").value(originAccessControlConfig.getSigningBehavior()).endElement();
                }
                if (originAccessControlConfig.getOriginAccessControlOriginType() != null) {
                    xmlWriter.startElement("OriginAccessControlOriginType").value(originAccessControlConfig.getOriginAccessControlOriginType()).endElement();
                }
                xmlWriter.endElement();
            }
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

