/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudwatch.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ManagedRule
implements Serializable,
Cloneable {
    private String templateName;
    private String resourceARN;
    private SdkInternalList<Tag> tags;

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public ManagedRule withTemplateName(String templateName) {
        this.setTemplateName(templateName);
        return this;
    }

    public void setResourceARN(String resourceARN) {
        this.resourceARN = resourceARN;
    }

    public String getResourceARN() {
        return this.resourceARN;
    }

    public ManagedRule withResourceARN(String resourceARN) {
        this.setResourceARN(resourceARN);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public ManagedRule withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public ManagedRule withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTemplateName() != null) {
            sb.append("TemplateName: ").append(this.getTemplateName()).append(",");
        }
        if (this.getResourceARN() != null) {
            sb.append("ResourceARN: ").append(this.getResourceARN()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedRule)) {
            return false;
        }
        ManagedRule other = (ManagedRule)obj;
        if (other.getTemplateName() == null ^ this.getTemplateName() == null) {
            return false;
        }
        if (other.getTemplateName() != null && !other.getTemplateName().equals(this.getTemplateName())) {
            return false;
        }
        if (other.getResourceARN() == null ^ this.getResourceARN() == null) {
            return false;
        }
        if (other.getResourceARN() != null && !other.getResourceARN().equals(this.getResourceARN())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTemplateName() == null ? 0 : this.getTemplateName().hashCode());
        hashCode = 31 * hashCode + (this.getResourceARN() == null ? 0 : this.getResourceARN().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public ManagedRule clone() {
        try {
            return (ManagedRule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

