/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sqs.model.Message;
import java.util.Map;

@SdkInternalApi
public class MessageMarshaller {
    private static final MarshallingInfo<String> MESSAGEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MessageId").build();
    private static final MarshallingInfo<String> RECEIPTHANDLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReceiptHandle").build();
    private static final MarshallingInfo<String> MD5OFBODY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MD5OfBody").build();
    private static final MarshallingInfo<String> BODY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Body").build();
    private static final MarshallingInfo<Map> ATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").build();
    private static final MarshallingInfo<String> MD5OFMESSAGEATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MD5OfMessageAttributes").build();
    private static final MarshallingInfo<Map> MESSAGEATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MessageAttributes").build();
    private static final MessageMarshaller instance = new MessageMarshaller();

    public static MessageMarshaller getInstance() {
        return instance;
    }

    public void marshall(Message message, ProtocolMarshaller protocolMarshaller) {
        if (message == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(message.getMessageId(), MESSAGEID_BINDING);
            protocolMarshaller.marshall(message.getReceiptHandle(), RECEIPTHANDLE_BINDING);
            protocolMarshaller.marshall(message.getMD5OfBody(), MD5OFBODY_BINDING);
            protocolMarshaller.marshall(message.getBody(), BODY_BINDING);
            protocolMarshaller.marshall(message.getAttributes(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall(message.getMD5OfMessageAttributes(), MD5OFMESSAGEATTRIBUTES_BINDING);
            protocolMarshaller.marshall(message.getMessageAttributes(), MESSAGEATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

