/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.notification;

import com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import com.amazonaws.services.simpleemail.model.Body;
import com.amazonaws.services.simpleemail.model.Content;
import com.amazonaws.services.simpleemail.model.Destination;
import com.amazonaws.services.simpleemail.model.Message;
import com.amazonaws.services.simpleemail.model.SendEmailRequest;
import java.util.Arrays;
import org.duracloud.notification.Emailer;

public class AmazonEmailer
implements Emailer {
    private AmazonSimpleEmailService emailService;
    private String fromAddress;

    public AmazonEmailer(AmazonSimpleEmailService emailService, String fromAddress) {
        this.emailService = emailService;
        this.fromAddress = fromAddress;
    }

    public void send(String subject, String body, String ... recipients) {
        Body requestBody = new Body().withText(new Content(body));
        this.sendEmail(subject, requestBody, recipients);
    }

    public void sendAsHtml(String subject, String body, String ... recipients) {
        Body requestBody = new Body().withHtml(new Content(body));
        this.sendEmail(subject, requestBody, recipients);
    }

    private void sendEmail(String subject, Body body, String ... recipients) {
        Destination destination = new Destination(Arrays.asList(recipients));
        Message msg = new Message().withBody(body).withSubject(new Content(subject));
        SendEmailRequest request = new SendEmailRequest().withSource(this.fromAddress).withDestination(destination).withMessage(msg);
        this.emailService.sendEmail(request);
    }
}

