/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.notification;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceAsyncClientBuilder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.notification.AmazonEmailer;
import org.duracloud.notification.Emailer;
import org.duracloud.notification.NotificationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonNotificationFactory
implements NotificationFactory {
    private static final Logger log = LoggerFactory.getLogger(AmazonNotificationFactory.class);
    private AmazonSimpleEmailService emailService;
    private Map<String, Emailer> emailerMap = new HashMap<String, Emailer>();

    public void initialize(String accessKey, String secretKey) {
        if (StringUtils.isNotBlank((CharSequence)accessKey)) {
            log.debug("initialize email service with provided credentials");
            this.emailService = (AmazonSimpleEmailService)((AmazonSimpleEmailServiceAsyncClientBuilder)AmazonSimpleEmailServiceAsyncClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey)))).build();
        } else {
            log.debug("initialize email service using the default AWS Default Credentials Chain provider");
            this.emailService = AmazonSimpleEmailServiceAsyncClientBuilder.defaultClient();
        }
    }

    public Emailer getEmailer(String fromAddress) {
        if (null == fromAddress || !EmailValidator.getInstance().isValid(fromAddress)) {
            String msg = "fromAddress not valid notification: " + fromAddress;
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        if (null == this.emailService) {
            String msg = "Emailer service !initialized.";
            log.error(msg);
            throw new DuraCloudRuntimeException(msg);
        }
        Emailer emailer = this.emailerMap.get(fromAddress);
        if (null == emailer) {
            emailer = new AmazonEmailer(this.emailService, fromAddress);
            this.emailerMap.put(fromAddress, emailer);
        }
        return emailer;
    }
}

