/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.notification;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.duracloud.notification.Emailer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class SMTPEmailer
implements Emailer {
    private static final Logger log = LoggerFactory.getLogger(SMTPEmailer.class);
    private JavaMailSenderImpl emailService;
    private String fromAddress;

    public SMTPEmailer(JavaMailSenderImpl emailService, String fromAddress) {
        this.emailService = emailService;
        this.fromAddress = fromAddress;
    }

    public void send(String subject, String body, String ... recipients) {
        this.sendEmail(subject, body, false, recipients);
    }

    public void sendAsHtml(String subject, String body, String ... recipients) {
        this.sendEmail(subject, body, true, recipients);
    }

    private void sendEmail(String subject, String messageStr, boolean isHtml, String ... recipients) {
        MimeMessage message = this.emailService.createMimeMessage();
        MimeMessageHelper messageHelper = new MimeMessageHelper(message);
        try {
            messageHelper.setFrom(this.fromAddress);
            messageHelper.setSubject(subject);
            messageHelper.setTo(recipients);
            messageHelper.setText(messageStr, isHtml);
        }
        catch (MessagingException ex) {
            log.error("Failed to prepare email message {}", (Object)ex.getMessage());
        }
        try {
            this.emailService.send(message);
        }
        catch (MailException ex) {
            log.error("Failed to send email because: {}", (Object)ex.getMessage());
        }
    }
}

