/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.notification;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.MessagingException;
import org.apache.commons.validator.routines.EmailValidator;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.notification.Emailer;
import org.duracloud.notification.NotificationFactory;
import org.duracloud.notification.SMTPEmailer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSenderImpl;

public class SMTPNotificationFactory
implements NotificationFactory {
    private static final Logger log = LoggerFactory.getLogger(SMTPNotificationFactory.class);
    private JavaMailSenderImpl emailService;
    private Map<String, Emailer> emailerMap = new HashMap<String, Emailer>();
    private String host;
    private Integer port;

    public SMTPNotificationFactory(String host, Integer port) {
        this.host = host;
        this.port = port;
    }

    public void initialize(String username, String password) {
        Object logUserMsg = "";
        this.emailService = new JavaMailSenderImpl();
        Properties mailProperties = new Properties();
        if (username != null && !username.isEmpty()) {
            mailProperties.put("mail.smtp.auth", "true");
            this.emailService.setUsername(username.trim());
            this.emailService.setPassword(password.trim());
            logUserMsg = ", User: " + username;
        }
        mailProperties.put("mail.smtp.starttls.enable", "true");
        mailProperties.put("mail.smtp.starttls.required", "true");
        this.emailService.setJavaMailProperties(mailProperties);
        this.emailService.setProtocol("smtp");
        this.emailService.setHost(this.host.trim());
        this.emailService.setPort(this.port.intValue());
        try {
            this.emailService.testConnection();
            log.debug("Email connection test passed: SMTP client connected to {}, Port: {}" + (String)logUserMsg, (Object)this.host, (Object)this.port);
        }
        catch (MessagingException ex) {
            log.error("Email connection test failed when connecting to {}, Port: {}" + (String)logUserMsg + ", because {}", new Object[]{this.host, this.port, ex.getMessage()});
        }
    }

    public Emailer getEmailer(String fromAddress) {
        if (null == fromAddress || !EmailValidator.getInstance().isValid(fromAddress)) {
            String msg = "fromAddress " + fromAddress + " is not valid. Email notification service NOT initialized.";
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        if (null == this.emailService) {
            String msg = "emailService is null. Email notification service NOT initialized.";
            log.error(msg);
            throw new DuraCloudRuntimeException(msg);
        }
        Emailer emailer = this.emailerMap.get(fromAddress);
        if (null == emailer) {
            emailer = new SMTPEmailer(this.emailService, fromAddress);
            this.emailerMap.put(fromAddress, emailer);
        }
        return emailer;
    }
}

