/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.client.report;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.duracloud.client.report.BaseReportManager;
import org.duracloud.client.report.StorageReportManager;
import org.duracloud.client.report.error.NotFoundException;
import org.duracloud.client.report.error.ReportException;
import org.duracloud.common.web.RestHttpHelper;
import org.duracloud.reportdata.storage.StorageReport;
import org.duracloud.reportdata.storage.StorageReportInfo;
import org.duracloud.reportdata.storage.StorageReportList;
import org.duracloud.reportdata.storage.serialize.StorageReportInfoSerializer;
import org.duracloud.reportdata.storage.serialize.StorageReportListSerializer;
import org.duracloud.reportdata.storage.serialize.StorageReportSerializer;

public class StorageReportManagerImpl
extends BaseReportManager
implements StorageReportManager {
    public StorageReportManagerImpl(String host, String port) {
        super(host, port);
    }

    public StorageReportManagerImpl(String host, String port, String context) {
        super(host, port, context);
    }

    private String buildURL(String relativeURL) {
        String storageReport = "report/storage";
        if (null == relativeURL) {
            return this.getBaseURL() + "/" + storageReport;
        }
        return this.getBaseURL() + "/" + storageReport + "/" + relativeURL;
    }

    private String buildBaseStorageReportURL() {
        return this.buildURL(null);
    }

    private String buildGetStorageReportListURL() {
        return this.buildURL("list");
    }

    private String buildGetStorageReportURL(String reportId) {
        return this.buildURL(reportId);
    }

    private String buildGetStorageReportInfoURL() {
        return this.buildURL("info");
    }

    private String buildScheduleStorageReportURL(long startTime, long frequency) {
        String baseUrl = this.buildURL("schedule");
        return baseUrl + "?startTime=" + startTime + "&frequency=" + frequency;
    }

    private String buildCancelStorageReportScheduleURL() {
        return this.buildURL("schedule");
    }

    @Override
    public StorageReport getLatestStorageReport() throws NotFoundException, ReportException {
        String url = this.buildBaseStorageReportURL();
        try {
            RestHttpHelper.HttpResponse response = this.getRestHelper().get(url);
            this.checkResponse(response, 200);
            InputStream reportXml = response.getResponseStream();
            StorageReportSerializer serializer = new StorageReportSerializer();
            return (StorageReport)serializer.deserialize(reportXml);
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            String error = "Could not get latest storage report due to: " + e.getMessage();
            throw new ReportException(error, e);
        }
    }

    @Override
    public List<String> getStorageReportList() throws ReportException {
        String url = this.buildGetStorageReportListURL();
        try {
            RestHttpHelper.HttpResponse response = this.getRestHelper().get(url);
            this.checkResponse(response, 200);
            InputStream listXml = response.getResponseStream();
            StorageReportList reportList = (StorageReportList)new StorageReportListSerializer().deserialize(listXml);
            ArrayList reportIds = reportList.getStorageReportList();
            if (null == reportIds) {
                reportIds = new ArrayList();
            }
            return reportIds;
        }
        catch (Exception e) {
            String error = "Could not get storage report list due to: " + e.getMessage();
            throw new ReportException(error, e);
        }
    }

    @Override
    public StorageReport getStorageReport(String reportId) throws NotFoundException, ReportException {
        String url = this.buildGetStorageReportURL(reportId);
        try {
            RestHttpHelper.HttpResponse response = this.getRestHelper().get(url);
            this.checkResponse(response, 200);
            InputStream reportXml = response.getResponseStream();
            StorageReportSerializer serializer = new StorageReportSerializer();
            return (StorageReport)serializer.deserialize(reportXml);
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            String error = "Could not get storage report with ID " + reportId + " due to: " + e.getMessage();
            throw new ReportException(error, e);
        }
    }

    @Override
    public StorageReportInfo getStorageReportInfo() throws ReportException {
        String url = this.buildGetStorageReportInfoURL();
        try {
            RestHttpHelper.HttpResponse response = this.getRestHelper().get(url);
            this.checkResponse(response, 200);
            InputStream reportInfoXml = response.getResponseStream();
            StorageReportInfoSerializer serializer = new StorageReportInfoSerializer();
            return (StorageReportInfo)serializer.deserialize(reportInfoXml);
        }
        catch (Exception e) {
            String error = "Could not get storage report info due to: " + e.getMessage();
            throw new ReportException(error, e);
        }
    }

    @Override
    public String startStorageReport() throws ReportException {
        String url = this.buildBaseStorageReportURL();
        try {
            RestHttpHelper.HttpResponse response = this.getRestHelper().post(url, null, null);
            this.checkResponse(response, 200);
            return response.getResponseBody();
        }
        catch (Exception e) {
            String error = "Could not start storage report due to: " + e.getMessage();
            throw new ReportException(error, e);
        }
    }

    @Override
    public String cancelStorageReport() throws ReportException {
        String url = this.buildBaseStorageReportURL();
        try {
            RestHttpHelper.HttpResponse response = this.getRestHelper().delete(url);
            this.checkResponse(response, 200);
            return response.getResponseBody();
        }
        catch (Exception e) {
            String error = "Could not cancel storage report due to: " + e.getMessage();
            throw new ReportException(error, e);
        }
    }

    @Override
    public String scheduleStorageReport(Date startTime, long frequency) throws ReportException {
        if (null == startTime) {
            throw new ReportException("Start time may not be null");
        }
        if (startTime.before(new Date())) {
            throw new ReportException("Start time must be in the future");
        }
        if (frequency < 600000L) {
            throw new ReportException("Frequency must be higher than 600000 milliseconds (10 minutes)");
        }
        String url = this.buildScheduleStorageReportURL(startTime.getTime(), frequency);
        try {
            RestHttpHelper.HttpResponse response = this.getRestHelper().post(url, null, null);
            this.checkResponse(response, 200);
            return response.getResponseBody();
        }
        catch (Exception e) {
            String error = "Could not schedule storage report due to: " + e.getMessage();
            throw new ReportException(error, e);
        }
    }

    @Override
    public String cancelStorageReportSchedule() throws ReportException {
        String url = this.buildCancelStorageReportScheduleURL();
        try {
            RestHttpHelper.HttpResponse response = this.getRestHelper().delete(url);
            this.checkResponse(response, 200);
            return response.getResponseBody();
        }
        catch (Exception e) {
            String error = "Could not cancel storage report schedule due to: " + e.getMessage();
            throw new ReportException(error, e);
        }
    }
}

