/*
 * The contents of this file are subject to the license and copyright
 * detailed in the LICENSE and NOTICE files at the root of the source
 * tree and available online at
 *
 *     http://duracloud.org/license/
 */
package org.duracloud.reportdata.storage.metrics;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import java.util.List;

/**
 * @author: Bill Branan
 * Date: 5/12/11
 */
public abstract class Metrics {

    @XmlElement
    private long totalItems;

    @XmlElement
    private long totalSize;

    @XmlElementWrapper
    @XmlElement(name = "mimetype")
    private List<MimetypeMetrics> mimetypeMetrics;

    // Required for JAXB
    protected Metrics() {
    }

    public Metrics(long totalItems,
                   long totalSize,
                   List<MimetypeMetrics> mimetypeMetrics) {
        this.totalItems = totalItems;
        this.totalSize = totalSize;
        this.mimetypeMetrics = mimetypeMetrics;
    }

    public long getTotalItems() {
        return totalItems;
    }

    public long getTotalSize() {
        return totalSize;
    }

    public List<MimetypeMetrics> getMimetypeMetrics() {
        return mimetypeMetrics;
    }

    /*
     * Generated by IntelliJ
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Metrics metrics = (Metrics) o;

        if (totalItems != metrics.totalItems) {
            return false;
        }
        if (totalSize != metrics.totalSize) {
            return false;
        }
        if (mimetypeMetrics != null ? !mimetypeMetrics
            .equals(metrics.mimetypeMetrics) :
            metrics.mimetypeMetrics != null) {
            return false;
        }

        return true;
    }

    /*
     * Generated by IntelliJ
     */
    @Override
    public int hashCode() {
        int result = (int) (totalItems ^ (totalItems >>> 32));
        result = 31 * result + (int) (totalSize ^ (totalSize >>> 32));
        result = 31 * result +
            (mimetypeMetrics != null ? mimetypeMetrics.hashCode() : 0);
        return result;
    }

}
