/*
 * The contents of this file are subject to the license and copyright
 * detailed in the LICENSE and NOTICE files at the root of the source
 * tree and available online at
 *
 *     http://duracloud.org/license/
 */
package org.duracloud.reportdata.storage.metrics;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import java.util.List;

/**
 * Top level metrics storage data structure for DuraStore. Contains all
 * metrics information for all storage providers.
 *
 * @author: Bill Branan
 * Date: 5/12/11
 */
public class StorageMetrics extends Metrics {

    @XmlElementWrapper
    @XmlElement(name = "storageProvider")
    private List<StorageProviderMetrics> storageProviderMetrics;

    // Required for JAXB
    private StorageMetrics() {
    }

    public StorageMetrics(List<StorageProviderMetrics> storageProviderMetrics,
                          long totalItems,
                          long totalSize,
                          List<MimetypeMetrics> mimetypeMetrics) {
        super(totalItems, totalSize, mimetypeMetrics);
        this.storageProviderMetrics = storageProviderMetrics;
    }

    public List<StorageProviderMetrics> getStorageProviderMetrics() {
        return storageProviderMetrics;
    }

    /*
     * Generated by IntelliJ
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        StorageMetrics that = (StorageMetrics) o;

        if (storageProviderMetrics != null ? !storageProviderMetrics
            .equals(that.storageProviderMetrics) :
            that.storageProviderMetrics != null) {
            return false;
        }

        return true;
    }

    /*
     * Generated by IntelliJ
     */
    @Override
    public int hashCode() {
        return storageProviderMetrics != null ? storageProviderMetrics
            .hashCode() : 0;
    }

}
