/*
 * The contents of this file are subject to the license and copyright
 * detailed in the LICENSE and NOTICE files at the root of the source
 * tree and available online at
 *
 *     http://duracloud.org/license/
 */
package org.duracloud.reportdata.storage;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.duracloud.reportdata.storage.metrics.StorageMetrics;

/**
 * @author: Bill Branan
 * Date: 6/1/11
 */
@XmlRootElement
public class StorageReport extends StorageReportBase {

    @XmlElement
    private String reportId;

    @XmlElement
    private StorageMetrics storageMetrics;

    @XmlElement
    private long completionTime;

    @XmlElement
    private long elapsedTime;

    // Required for JAXB
    public StorageReport() {
    }

    public StorageReport(String reportId,
                         StorageMetrics storageMetrics,
                         long completionTime,
                         long elapsedTime) {
        this.reportId = reportId;
        this.storageMetrics = storageMetrics;
        this.completionTime = completionTime;
        this.elapsedTime = elapsedTime;
        this.schemaVersion = SCHEMA_VERSION;
    }

    public String getReportId() {
        return reportId;
    }

    public StorageMetrics getStorageMetrics() {
        return storageMetrics;
    }

    public long getCompletionTime() {
        return completionTime;
    }

    public long getElapsedTime() {
        return elapsedTime;
    }

    /*
     * Generated by IntelliJ
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        StorageReport that = (StorageReport) o;

        if (completionTime != that.completionTime) {
            return false;
        }
        if (elapsedTime != that.elapsedTime) {
            return false;
        }
        if (reportId != null ? !reportId.equals(that.reportId) :
            that.reportId != null) {
            return false;
        }
        if (storageMetrics != null ? !storageMetrics
            .equals(that.storageMetrics) : that.storageMetrics != null) {
            return false;
        }

        return true;
    }

    /*
     * Generated by IntelliJ
     */
    @Override
    public int hashCode() {
        int result = reportId != null ? reportId.hashCode() : 0;
        result = 31 * result +
                 (storageMetrics != null ? storageMetrics.hashCode() : 0);
        result = 31 * result + (int) (completionTime ^ (completionTime >>> 32));
        result = 31 * result + (int) (elapsedTime ^ (elapsedTime >>> 32));
        return result;
    }

}
