/*
 * The contents of this file are subject to the license and copyright
 * detailed in the LICENSE and NOTICE files at the root of the source
 * tree and available online at
 *
 *     http://duracloud.org/license/
 */
package org.duracloud.reportdata.storage.metrics;

import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;

/**
 * Metrics data structure for spaces. Contains all of the metrics for a single
 * space.
 *
 * @author: Bill Branan
 * Date: 5/12/11
 */
public class SpaceMetrics extends Metrics {

    @XmlAttribute(name = "name")
    private String spaceName;

    // Required for JAXB
    private SpaceMetrics() {
    }

    public SpaceMetrics(String spaceName,
                        long totalItems,
                        long totalSize,
                        List<MimetypeMetrics> mimetypeMetrics) {
        super(totalItems, totalSize, mimetypeMetrics);
        this.spaceName = spaceName;
    }

    public String getSpaceName() {
        return spaceName;
    }

    /*
     * Generated by IntelliJ
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        SpaceMetrics that = (SpaceMetrics) o;

        if (spaceName != null ? !spaceName.equals(that.spaceName) :
            that.spaceName != null) {
            return false;
        }

        return true;
    }

    /*
     * Generated by IntelliJ
     */
    @Override
    public int hashCode() {
        return spaceName != null ? spaceName.hashCode() : 0;
    }

}
