/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.reporter.storage;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.duracloud.client.ContentStore;
import org.duracloud.client.ContentStoreManager;
import org.duracloud.common.error.DuraCloudCheckedException;
import org.duracloud.error.ContentStoreException;
import org.duracloud.reportdata.storage.StorageReport;
import org.duracloud.reporter.error.ReportBuilderException;
import org.duracloud.reporter.error.StorageReportCancelledException;
import org.duracloud.reporter.storage.StorageReportHandler;
import org.duracloud.reporter.storage.metrics.DuraStoreMetricsCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageReportBuilder
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(StorageReportBuilder.class);
    public static final int maxRetries = 20;
    private ContentStoreManager storeMgr = null;
    private StorageReportHandler reportHandler;
    private Status status;
    private String error;
    private long startTime;
    private long stopTime;
    private long elapsedTime;
    private boolean run;
    private DuraStoreMetricsCollector durastoreMetrics;

    public StorageReportBuilder(ContentStoreManager storeMgr, StorageReportHandler reportHandler) {
        this.storeMgr = storeMgr;
        this.reportHandler = reportHandler;
        this.status = Status.CREATED;
        this.error = null;
        this.startTime = 0L;
        this.stopTime = 0L;
        this.elapsedTime = 0L;
        try {
            StorageReport lastReport = reportHandler.getLatestStorageReport();
            if (null != lastReport) {
                this.stopTime = lastReport.getCompletionTime();
                this.elapsedTime = lastReport.getElapsedTime();
            }
        }
        catch (Exception e) {
            this.log.warn("Unable to retrieve latest storage report due to: " + e.getMessage());
        }
    }

    @Override
    public void run() {
        this.run = true;
        this.error = null;
        this.startTime = System.currentTimeMillis();
        this.log.info("Storage Report starting at time: " + this.startTime);
        this.status = Status.RUNNING;
        try {
            this.collectStorageMetrics();
            this.stopTime = System.currentTimeMillis();
            this.elapsedTime = this.stopTime - this.startTime;
            this.reportHandler.storeReport(this.durastoreMetrics, this.stopTime, this.elapsedTime);
            this.status = Status.COMPLETE;
            this.log.info("Storage Report completed at time: " + this.stopTime);
        }
        catch (StorageReportCancelledException e) {
            this.stopTime = System.currentTimeMillis();
            this.log.warn("Storage Report cancelled at: " + this.stopTime);
            this.status = Status.CANCELLED;
        }
        catch (ReportBuilderException e) {
            String errMsg;
            this.stopTime = System.currentTimeMillis();
            this.error = errMsg = "Unable to complete metrics collection due to: " + e.getMessage();
            this.log.error(errMsg);
            this.reportHandler.addToErrorLog(errMsg);
            this.status = Status.ERROR;
        }
        catch (Exception e) {
            String errMsg;
            this.stopTime = System.currentTimeMillis();
            this.error = errMsg = "Unable to complete metrics collection due to: exception of type " + e.getClass() + " with message: " + e.getMessage();
            this.log.error(errMsg, (Throwable)e);
            this.reportHandler.addToErrorLog(errMsg);
            this.status = Status.ERROR;
        }
    }

    public void cancelReport() {
        new DuraCloudCheckedException();
        this.log.info("Cancelling Storage Report");
        this.run = false;
    }

    private void collectStorageMetrics() {
        this.durastoreMetrics = new DuraStoreMetricsCollector();
        Map<String, ContentStore> contentStores = this.retryGetContentStores();
        for (ContentStore contentStore : contentStores.values()) {
            this.checkRun();
            String storeId = contentStore.getStoreId();
            String storeType = contentStore.getStorageProviderType();
            for (String spaceId : this.retryGetSpaces(contentStore)) {
                this.checkRun();
                Iterator<String> contentIds = this.retryGetSpaceContents(contentStore, spaceId);
                while (contentIds.hasNext()) {
                    this.checkRun();
                    String contentId = contentIds.next();
                    Map<String, String> contentProperties = this.retryGetContentProperties(contentStore, spaceId, contentId);
                    this.updateMetrics(contentProperties, storeId, storeType, spaceId);
                }
            }
        }
    }

    private void updateMetrics(Map<String, String> contentProperties, String storeId, String storeType, String spaceId) {
        if (null != contentProperties) {
            String mimetype = contentProperties.get("content-mimetype");
            long size = this.convert(contentProperties.get("content-size"));
            this.durastoreMetrics.update(storeId, storeType, spaceId, mimetype, size);
        }
    }

    private Map<String, ContentStore> retryGetContentStores() {
        for (int i = 0; i < 20; ++i) {
            this.checkRun();
            try {
                return this.storeMgr.getContentStores();
            }
            catch (ContentStoreException e) {
                this.log.warn("Exception attempting to retrieve content stores list: " + e.getMessage());
                this.wait(i);
                continue;
            }
        }
        throw new ReportBuilderException("Exceeded retries attempting to retrieve content stores list");
    }

    private List<String> retryGetSpaces(ContentStore contentStore) {
        for (int i = 0; i < 20; ++i) {
            this.checkRun();
            try {
                return contentStore.getSpaces();
            }
            catch (ContentStoreException e) {
                String store = this.getStoreInfo(contentStore);
                this.log.warn("Exception attempting to retrieve spaces list for store: " + store + " due to: " + e.getMessage());
                this.wait(i);
                continue;
            }
        }
        throw new ReportBuilderException("Exceeded retries attempting to retrieve spaces list");
    }

    private Iterator<String> retryGetSpaceContents(ContentStore contentStore, String spaceId) {
        for (int i = 0; i < 20; ++i) {
            this.checkRun();
            try {
                return contentStore.getSpaceContents(spaceId);
            }
            catch (ContentStoreException e) {
                String store = this.getStoreInfo(contentStore);
                this.log.warn("Exception attempting to retrieve space contents list (for " + spaceId + " in store " + store + "): " + e.getMessage());
                this.wait(i);
                continue;
            }
        }
        throw new ReportBuilderException("Exceeded retries attempting to retrieve space contents list (for " + spaceId + ")");
    }

    private Map<String, String> retryGetContentProperties(ContentStore contentStore, String spaceId, String contentId) {
        for (int i = 0; i < 20; ++i) {
            this.checkRun();
            try {
                return contentStore.getContentProperties(spaceId, contentId);
            }
            catch (ContentStoreException e) {
                String store = this.getStoreInfo(contentStore);
                this.log.warn("Exception attempting to retrieve content properties (for " + spaceId + ":" + contentId + " in store " + store + "): " + e.getMessage());
                this.wait(i);
                continue;
            }
        }
        this.log.error("Exceeded retries attempting to retrieve content properties (for " + spaceId + ":" + contentId + "). Skipping item.");
        return null;
    }

    private String getStoreInfo(ContentStore contentStore) {
        return contentStore.getStoreId() + "(" + contentStore.getStorageProviderType() + ")";
    }

    private long convert(String sizeStr) {
        try {
            return Long.valueOf(sizeStr);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private void wait(int index) {
        this.checkRun();
        try {
            Thread.sleep(1000 * index);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void checkRun() {
        if (!this.run) {
            throw new StorageReportCancelledException();
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public String getError() {
        return this.error;
    }

    public long getCurrentCount() {
        return this.durastoreMetrics.getTotalItems();
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public static enum Status {
        CREATED,
        RUNNING,
        COMPLETE,
        CANCELLED,
        ERROR;

    }
}

