/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.reporter.storage;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.duracloud.reporter.storage.StorageReportBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageReportScheduler {
    private StorageReportBuilder reportBuilder;
    private Timer timer;
    private Date startDate;
    private long frequency;
    private final Logger log = LoggerFactory.getLogger(StorageReportScheduler.class);

    public StorageReportScheduler(StorageReportBuilder reportBuilder) {
        this.reportBuilder = reportBuilder;
        this.timer = new Timer();
        this.startDate = null;
        this.frequency = 0L;
    }

    public String scheduleStorageReport(Date startDate, long frequency) {
        this.timer = new Timer();
        this.startDate = startDate;
        this.frequency = frequency;
        this.timer.scheduleAtFixedRate((TimerTask)new ReportTask(), startDate, frequency);
        String success = "Storage reports scheduled to begin on " + startDate + " and repeat every " + frequency / 60000L + " minutes";
        this.log.info(success);
        return success;
    }

    public String cancelStorageReportSchedule() {
        this.timer = new Timer();
        this.startDate = null;
        this.frequency = 0L;
        String success = "Storage Reports schedule cancelled.";
        this.log.info(success);
        return success;
    }

    public String startStorageReport() {
        if (!this.builderRunning()) {
            this.timer.schedule((TimerTask)new ReportTask(), 0L);
            return "Storage Report Started";
        }
        long count = this.reportBuilder.getCurrentCount();
        return "Report Already In Progress, " + count + " items counted";
    }

    public String cancelStorageReport() {
        if (this.builderRunning()) {
            this.reportBuilder.cancelReport();
            return "Storage report cancelled";
        }
        return "No storage report is currently running";
    }

    private boolean builderRunning() {
        StorageReportBuilder.Status builderStatus = this.reportBuilder.getStatus();
        return builderStatus.equals((Object)StorageReportBuilder.Status.RUNNING);
    }

    public Date getNextScheduledStartDate() {
        if (null != this.startDate) {
            Date scheduledDate = this.startDate;
            Date now = new Date();
            while (scheduledDate.before(now)) {
                scheduledDate = new Date(scheduledDate.getTime() + this.frequency);
            }
            return scheduledDate;
        }
        return null;
    }

    private class ReportTask
    extends TimerTask {
        private ReportTask() {
        }

        @Override
        public void run() {
            if (!StorageReportScheduler.this.builderRunning()) {
                this.runStorageReport();
            }
        }

        private void runStorageReport() {
            Thread builderThread = new Thread(StorageReportScheduler.this.reportBuilder);
            builderThread.start();
        }
    }
}

